% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotsNtables.R
\name{summaryBarPlot}
\alias{summaryBarPlot}
\title{Create barplot from backtest summary}
\usage{
summaryBarPlot(bt_summary, measures = NULL, type = c("ggplot2",
  "simple"), ...)
}
\arguments{
\item{bt_summary}{Backtest summary as obtained from the function \code{backtestSummary}.}

\item{measures}{String vector to select performane measures (default is all) from
`Sharpe ratio`, `max drawdown`, `annual return`, `annual volatility`, 
`Sterling ratio`, `Omega ratio`, and `ROT bps`.}

\item{type}{Type of plot. Valid options: \code{"ggplot2", "simple"}. Default is 
\code{"ggplot2"}.}

\item{...}{Additional parameters (only used for plot \code{type = "simple"}); 
for example: \code{mar} for margins as in \code{par()},
             \code{inset} for the legend inset as in \code{legend()},
             \code{legend_loc} for the legend location as in \code{legend()}.}
}
\description{
After performing a backtest with \code{\link{portfolioBacktest}} 
and obtaining a summary of the performance measures with 
\code{\link{backtestSummary}}, this function creates a barplot from the summary. 
By default the plot is based on the package \code{ggplot2}, but the user
can also specify a simple base plot.
}
\examples{
\donttest{
library(portfolioBacktest)
data(dataset10)  # load dataset

# define your own portfolio function
quintile_portfolio <- function(data) {
  X <- diff(log(data$adjusted))[-1]  
  N <- ncol(X)
  ranking <- sort(colMeans(X), decreasing = TRUE, index.return = TRUE)$ix
  w <- rep(0, N)
  w[ranking[1:round(N/5)]] <- 1/round(N/5)
  return(w)
}

# do backtest
bt <- portfolioBacktest(list("Quintile" = quintile_portfolio), dataset10,
                        benchmark = c("uniform", "index"))
                        
# now we can obtain the table
bt_summary_median <- backtestSummary(bt)
summaryBarPlot(bt_summary_median, measures = c("max drawdown", "annual volatility"))
summaryBarPlot(bt_summary_median, measures = c("max drawdown", "annual volatility"), 
               type = "simple")
}

}
\seealso{
\code{\link{summaryTable}}, \code{\link{backtestBoxPlot}},
         \code{\link{backtestChartCumReturns}}, \code{\link{backtestChartDrawdown}},
         \code{\link{backtestChartStackedBar}}
}
\author{
Daniel P. Palomar and Rui Zhou
}
