% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pp_calc.R
\name{pp_calc}
\alias{pp_calc}
\title{Population Calculation}
\usage{
pp_calc(target, a, D)
}
\arguments{
\item{target}{object of class \code{sf}}

\item{a}{area/volume field}

\item{D}{density field}
}
\value{
an object of class \code{sf} including population values
}
\description{
Population Calculation
}
\examples{
    library(populR)

    data('source')
    data('target')

    # area calculation
    pp_area <- pp_a(target = target)

    # density calculation using area
    pp_density_a <- pp_D(source = source, target = pp_area, sourcecode = sid,
        sourcepop = pop, area = pp_a)

    # population calculation using area
    pp_pop_area <- pp_calc(target = pp_density_a, a = pp_a, D = pp_D)

    # volume calculation
    pp_volume <- pp_a(target = target, volume = floors)

    # density calculation using volume
    pp_density_v <- pp_D(source = source, target = pp_volume, sourcecode = sid,
        sourcepop = pop, area = pp_a)

    # population calculation using volume
    pp_pop_volume <- pp_calc(target = pp_density_v, a = pp_a, D = pp_D)


}
