% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pp_estimate.R
\name{pp_estimate}
\alias{pp_estimate}
\title{Population Down-scaling}
\usage{
pp_estimate(source, target, sourcepop, sourcecode, volume = NULL)
}
\arguments{
\item{source}{object of class \code{sf}}

\item{target}{object of class \code{sf}}

\item{sourcepop}{string of source pop column}

\item{sourcecode}{string of source id column}

\item{volume}{string of target floor/height column}
}
\value{
an object of class \code{sf} including population counts
}
\description{
Population Down-scaling
}
\examples{
    library(populR)
    data("target")
    data("source")

    # areametric
    pop_aw <- pp_estimate(source = source, target = target, sourcepop = 'pop',
        sourcecode = 'sid')

    #volumetric
    pop_vw <- pp_estimate(source = source, target = target, sourcepop = 'pop',
        sourcecode = 'sid', volume = 'floors')

}
\references{
Lwin, K. K., & Murayama, Y. (2009)
    \emph{A GIS approach to estimation of building population for micro-spatial analysis. Transactions in GIS, 13(4), 401–414.}
    \doi{https://doi.org/10.1111/j.1467-9671.2009.01171.x}
}
