% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/population_projection.R
\name{population_projection}
\alias{population_projection}
\title{population_projection}
\usage{
population_projection(...)
}
\arguments{
\item{...}{required arguments for \code{\link{mortality_projection}}, \code{\link{TFR_projection}} and \code{\link{netmigration_projection}}.}
}
\value{
\code{population_projection} returns an object of class \code{list} with the following components:

\item{mort}{mortality projections from \code{\link{mortality_projection}}.}
\item{fert}{fertility projections from \code{\link{TFR_projection}}.}
\item{mig}{netmigration projections from \code{\link{netmigration_projection}}.}
\item{pop}{the national projections by sex and year.}
}
\description{
Forecasting population using the components method.
}
\examples{

\donttest{
\dontrun{

library(dplyr)

data(CR_mortality_rates_1950_2011)

#CR_mortality_rates_1950_2011 \%>\%
#write.table(.,
#file = "CR_mortality_rates_1950_2011.txt",
#sep = "\t",
#row.names = FALSE,
#col.names = TRUE,
#quote = FALSE)


data(CR_populations_1950_2011)

#CR_populations_1950_2011 \%>\%
#write.table(.,
#file = "CR_populations_1950_2011.txt",
#sep = "\t",
#row.names = FALSE,
#col.names = TRUE,
#quote = FALSE)

data(CR_fertility_rates_1950_2011)

#CR_fertility_rates_1950_2011 \%>\%
#write.table(.,
#file = "CR_fertility_rates_1950_2011.txt",
#sep = "\t",
#row.names = FALSE,
#col.names = TRUE,
#quote = FALSE)


data(CR_women_childbearing_age_1950_2011)

#CR_women_childbearing_age_1950_2011 \%>\%
#write.table(.,
#file = "CR_women_childbearing_age_1950_2011.txt",
#sep = "\t",
#row.names = FALSE,
#col.names = TRUE,
#quote = FALSE)

#result <- population_projection(mortality_rates_path = "CR_mortality_rates_1950_2011.txt",
#total_population_path = "CR_populations_1950_2011.txt",
#TFR_path = "CR_fertility_rates_1950_2011.txt",
#WRA_path = "CR_women_childbearing_age_1950_2011.txt",
#omega_age = 115, first_year_projection = 2011, horizon = 2020)

}
}

}
\seealso{
\code{\link{mortality_projection}}
\code{\link{TFR_projection}}
\code{\link{netmigration_projection}}
}
\author{
Cesar Gamboa-Sanabria
}
