% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaaMLGmethods.R
\name{visible}
\alias{visible}
\alias{visible,MLG-method}
\alias{visible<-}
\alias{visible<-,MLG-method}
\alias{MLG2df}
\alias{MLG2df,MLG-method}
\alias{distname}
\alias{distname,MLG-method}
\alias{distenv}
\alias{distenv,MLG-method}
\alias{distname<-}
\alias{distname<-,MLG-method}
\alias{distenv<-}
\alias{distenv<-,MLG-method}
\alias{distargs}
\alias{distargs,MLG-method}
\alias{distargs<-}
\alias{distargs<-,MLG-method}
\alias{distalgo}
\alias{distalgo,MLG-method}
\alias{distalgo<-}
\alias{distalgo<-,MLG-method}
\alias{cutoff}
\alias{cutoff,MLG-method}
\alias{cutoff<-}
\alias{cutoff<-,MLG-method}
\title{Accessors for the MLG object}
\usage{
visible(x)

visible(x) <- value

MLG2df(x)

distname(x)

distenv(x)

distname(x) <- value

distenv(x) <- value

distargs(x)

distargs(x) <- value

distalgo(x)

distalgo(x) <- value

cutoff(x)

cutoff(x) <- value
}
\arguments{
\item{x}{an MLG object}

\item{value}{see details}
}
\value{
see details
}
\description{
\strong{This documentation is for developers of poppr.} The accessors here 
are preferred over accessing the elements via the @ symbol. Please use these
in your code when accessing MLG objects.
}
\details{
These accessors are intended for internal use only. They only affect
  MLG objects, not genind objects. Only visible and MLG2df are general for 
  all forms of MLG. The distargs and cutoff are specific for use in 
  mlg.filter or any function that offers filtering as an option. The argument
  "value" will always take the type defined in the \code{\linkS4class{MLG}} 
  class.
}
\examples{

\dontrun{
# These examples will simply show you what you can do with these
set.seed(5000)
(x <- sample(10, 20, replace = TRUE))
(m <- new("MLG", x))

# Visibility ------------------------------
visible(m) # original
visible(m) <- "contracted"
m          # shows contracted MLGS

# Conversion to data frame ----------------
MLG2df(m)  # Grab the internal data frame

# Distance function handling --------------
distname(m) # nei.dist
distargs(m) # list()
distalgo(m) # farthest
cutoff(m)

distname(m) <- substitute("diss.dist")
distargs(m) <- list(percent = TRUE)
distalgo(m) <- "average"
cutoff(m)["contracted"] <- 0.2

}
}
\seealso{
\code{\link{MLG}} \code{\linkS4class{genclone}} 
  \code{\link[adegenet:genlight-class]{genlight}} \code{\link{initialize,MLG-method}}
  \code{\link{levels,MLG-method}} \code{\link{unique,MLG-method}}
}
\keyword{internal}
