% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{nematode}
\alias{nematode}
\title{Population densities for the sugarbeet cyst nematode}
\format{A matrix listing densities from  3 stage classes over 6 time periods}
\source{
Example 6.3 in Caswell (2001).
}
\usage{
nematode
}
\description{
A time-series of population vectors for the sugarbeet cyst nematode
\emph{Heterodera schachtii}. Individuals were classified into three stages
(J2, J3+J4, and adult) and densities (per 60 cc of soil) were averaged over
four replicates, measured every two days, for 10 days. .
}
\examples{
nematode
stage.vector.plot(nematode,
  prop = FALSE, log = "y", ylim = c(.3, 200),
  xlab = "Time", ylab = "Nematode density"
)
}
\references{
Caswell, H. 2001. Matrix population models. Construction,
Analysis and interpretation. 2nd ed. Sinauer, Sunderland, Massachusetts.
}
\seealso{
\code{\link{QPmat}}
}
\keyword{datasets}
