% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.fitted.fstats.R
\name{compare.fitted.fstats}
\alias{compare.fitted.fstats}
\title{Compare fitted f2, f3 and f4 f-statistics of an admixture graph with estimated ones}
\usage{
compare.fitted.fstats(fstats, fitted.graph, n.worst.stats = 5)
}
\arguments{
\item{fstats}{Object of class fstats containing estimates of fstats (as obtained with compute.fstats)}

\item{fitted.graph}{Object of class fitted graph (as obtained with fit.graph function).}

\item{n.worst.stats}{The number of worst statistics to be displayed in the terminal}
}
\value{
A matrix with 3 columns for each test (row names of the matrix corresponding to the test):
\enumerate{
 \item The estimated f-statistics (mean across block-Jackknife samples)
 \item The fitted f-statistics (obtained from the fitted grah parameters
 \item A Z-score measuring the deviation of the fitted values from the estimated values in units of standard errors (i.e., Z=(fitted.value-target.value)/se(target.value))
}
}
\description{
Compare fitted f2, f3 and f4 f-statistics of an admixture graph with estimated ones
}
\details{
Compare fitted and estimated f-statistics may allow identifying problematic edges on the graph.
}
\seealso{
See \code{\link{compute.fstats}} and \code{\link{fit.graph}}
}
