% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_sumstats.R
\name{Het_Between}
\alias{Het_Between}
\title{Compute heterozygosity between all pairs of populations}
\usage{
Het_Between(Pop_Pi)
}
\arguments{
\item{Pop_Pi}{is a matrix or list of allele frequencies. When dealing with a
single locus, this input is a matrix and when dealing with multiple loci it
is a list. Each entry of that list is a matrix representing a different
locus. Each row of that matrix should correspond to a different population
and each column to a different SNP.}
}
\value{
if the input is a matrix, this will be a vector where each entry
represents the mean expected heterozygosity between two populations. When a
list is used as input, the output will also be a list and each entry of
that list will be a vector with the mean expected heterozygosity between
pairs of populations for that locus.
}
\description{
This function computes the value of the mean expected heterozygosity between
all pairwise combinations of different populations.
}
\details{
If you wish to see what the different combinations are, please run
\code{combn(nrow(Pop_Pi), m = 2)}. It should also be noted that the order of
the combinations obtained by using that command is the same as the order of
the output vector. This functions works when the input is a matrix or a list.
}
\keyword{internal}
