% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probe_match.R
\docType{methods}
\name{probe matching}
\alias{probe matching}
\alias{probe_objfun}
\alias{probe_objfun,missing-method}
\alias{probe_objfun,ANY-method}
\alias{probe_objfun,data.frame-method}
\alias{probe_objfun,pomp-method}
\alias{probe_objfun,probed_pomp-method}
\alias{probe_objfun,probe_match_objfun-method}
\title{Probe matching}
\usage{
\S4method{probe_objfun}{data.frame}(
  data,
  est = character(0),
  fail.value = NA,
  probes,
  nsim,
  seed = NULL,
  params,
  rinit,
  rprocess,
  rmeasure,
  partrans,
  ...,
  verbose = getOption("verbose", FALSE)
)

\S4method{probe_objfun}{pomp}(
  data,
  est = character(0),
  fail.value = NA,
  probes,
  nsim,
  seed = NULL,
  ...,
  verbose = getOption("verbose", FALSE)
)

\S4method{probe_objfun}{probed_pomp}(
  data,
  est = character(0),
  fail.value = NA,
  probes,
  nsim,
  seed = NULL,
  ...,
  verbose = getOption("verbose", FALSE)
)

\S4method{probe_objfun}{probe_match_objfun}(
  data,
  est,
  fail.value,
  seed = NULL,
  ...,
  verbose = getOption("verbose", FALSE)
)
}
\arguments{
\item{data}{either a data frame holding the time series data,
or an object of class \sQuote{pomp},
i.e., the output of another \pkg{pomp} calculation.
Internally, \code{data} will be internally coerced to an array with storage-mode \code{double}.}

\item{est}{character vector; the names of parameters to be estimated.}

\item{fail.value}{optional numeric scalar;
if non-\code{NA}, this value is substituted for non-finite values of the objective function.
It should be a large number (i.e., bigger than any legitimate values the objective function is likely to take).}

\item{probes}{a single probe or a list of one or more probes.
A probe is simply a scalar- or vector-valued function of one argument that can be applied to the data array of a \sQuote{pomp}.
A vector-valued probe must always return a vector of the same size.
A number of useful probes are provided with the package:
see \link[=basic probes]{basic probes}.}

\item{nsim}{the number of model simulations to be computed.}

\item{seed}{integer.
When fitting, it is often best to fix the seed of the random-number generator (RNG).
This is accomplished by setting \code{seed} to an integer.
By default, \code{seed = NULL}, which does not alter the RNG state.}

\item{params}{optional; named numeric vector of parameters.
This will be coerced internally to storage mode \code{double}.}

\item{rinit}{simulator of the initial-state distribution.
This can be furnished either as a C snippet, an \R function, or the name of a pre-compiled native routine available in a dynamically loaded library.
Setting \code{rinit=NULL} sets the initial-state simulator to its default.
For more information, see \link[=rinit specification]{rinit specification}.}

\item{rprocess}{simulator of the latent state process, specified using one of the \link[=rprocess specification]{rprocess plugins}.
Setting \code{rprocess=NULL} removes the latent-state simulator.
For more information, see \link[=rprocess specification]{rprocess specification for the documentation on these plugins}.}

\item{rmeasure}{simulator of the measurement model, specified either as a C snippet, an \R function, or the name of a pre-compiled native routine available in a dynamically loaded library.
Setting \code{rmeasure=NULL} removes the measurement model simulator.
For more information, see \link[=rmeasure specification]{rmeasure specification}.}

\item{partrans}{optional parameter transformations, constructed using \code{\link{parameter_trans}}.

Many algorithms for parameter estimation search an unconstrained space of parameters.
When working with such an algorithm and a model for which the parameters are constrained, it can be useful to transform parameters.
One should supply the \code{partrans} argument via a call to \code{\link{parameter_trans}}.
For more information, see \link[=parameter_trans]{parameter_trans}.
Setting \code{partrans=NULL} removes the parameter transformations, i.e., sets them to the identity transformation.}

\item{...}{additional arguments supply new or modify existing model characteristics or components.
See \code{\link{pomp}} for a full list of recognized arguments.

When named arguments not recognized by \code{\link{pomp}} are provided, these are made available to all basic components via the so-called \dfn{userdata} facility.
This allows the user to pass information to the basic components outside of the usual routes of covariates (\code{covar}) and model parameters (\code{params}).
See \link[=userdata]{userdata} for information on how to use this facility.}

\item{verbose}{logical; if \code{TRUE}, diagnostic messages will be printed to the console.}
}
\value{
\code{probe_objfun} constructs a stateful objective function for probe matching.
Specifically, \code{probe_objfun} returns an object of class \sQuote{probe_match_objfun}, which is a function suitable for use in an \code{\link[stats]{optim}}-like optimizer.
In particular, this function takes a single numeric-vector argument that is assumed to contain the parameters named in \code{est}, in that order.
When called, it will return the negative synthetic log likelihood for the probes specified.
It is a stateful function:
Each time it is called, it will remember the values of the parameters and its estimate of the synthetic likelihood.
}
\description{
Estimation of parameters by maximum synthetic likelihood
}
\details{
In probe-matching, one attempts to minimize the discrepancy between simulated and actual data, as measured by a set of summary statistics called \emph{probes}.
In \pkg{pomp}, this discrepancy is measured using the \dQuote{synthetic likelihood} as defined by Wood (2010).
}
\section{Note for Windows users}{


Some Windows users report problems when using C snippets in parallel computations.
These appear to arise when the temporary files created during the C snippet compilation process are not handled properly by the operating system.
To circumvent this problem, use the \code{\link[=pomp]{cdir}} and \code{\link[=pomp]{cfile}} options to cause the C snippets to be written to a file of your choice, thus avoiding the use of temporary files altogether.
}

\section{Important Note}{

Since \pkg{pomp} cannot guarantee that the \emph{final} call an optimizer makes to the function is a call \emph{at} the optimum, it cannot guarantee that the parameters stored in the function are the optimal ones.
Therefore, it is a good idea to evaluate the function on the parameters returned by the optimization routine, which will ensure that these parameters are stored.
}

\examples{
\donttest{
  gompertz() -> po
  
  ## A list of probes:
  plist <- list(
    mean=probe.mean("Y",trim=0.1,transform=sqrt),
    sd=probe.sd("Y",transform=sqrt),
    probe.marginal("Y",ref=obs(po)),
    probe.acf("Y",lags=c(1,3,5),type="correlation",transform=sqrt),
    probe.quantile("Y",prob=c(0.25,0.75),na.rm=TRUE)
  )

  ## Construct the probe-matching objective function.
  ## Here, we just want to estimate 'K'.
  po \%>\%
    probe_objfun(probes=plist,nsim=100,seed=5069977,
      est="K") -> f

  ## Any numerical optimizer can be used to minimize 'f'.
  library(subplex)

  subplex(fn=f,par=0.4,control=list(reltol=1e-5)) -> out

  ## Call the objective one last time on the optimal parameters:
  f(out$par)
  coef(f)

  ## There are 'plot' and 'summary' methods:
  f \%>\% as("probed_pomp") \%>\% plot()
  f \%>\% summary()

  ## One can convert an objective function to a data frame:
  f \%>\% as("data.frame") \%>\% head()
  f \%>\% as("probed_pomp") \%>\% as("data.frame") \%>\% head()

  f \%>\% probe() \%>\% plot()

  ## One can modify the objective function with another call
  ## to 'probe_objfun':

  f \%>\% probe_objfun(est=c("r","K")) -> f1
  subplex(fn=f1,par=c(0.3,0.3),control=list(reltol=1e-5)) -> out
  f1(out$par)
  coef(f1)
}
}
\seealso{
\code{\link[stats]{optim}} \code{\link[subplex]{subplex}} \code{\link[nloptr]{nloptr}}

More on methods based on summary statistics: 
\code{\link{approximate Bayesian computation}},
\code{\link{basic probes}},
\code{\link{nonlinear forecasting}},
\code{\link{probe}()},
\code{\link{spectrum matching}},
\code{\link{spect}()}

More on \pkg{pomp} estimation algorithms:
\code{\link{approximate Bayesian computation}},
\code{\link{bsmc2}()},
\code{\link{estimation algorithms}},
\code{\link{mif2}()},
\code{\link{nonlinear forecasting}},
\code{\link{pmcmc}()},
\code{\link{pomp-package}},
\code{\link{spectrum matching}}

More on maximization-based estimation methods:
\code{\link{mif2}()},
\code{\link{nonlinear forecasting}},
\code{\link{spectrum matching}},
\code{\link{trajectory matching}}
}
\author{
Aaron A. King
}
\concept{estimation methods}
\concept{methods based on maximization}
\concept{probe matching}
\concept{summary statistic-based methods}
\concept{synthetic likelihood}
