% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workhorses.R
\docType{methods}
\name{dmeasure}
\alias{dmeasure}
\alias{dmeasure,pomp-method}
\alias{dmeasure-pomp}
\alias{dmeasure,ANY-method}
\alias{dmeasure,missing-method}
\title{dmeasure}
\usage{
\S4method{dmeasure}{pomp}(object, y, x, times, params, ..., log = FALSE)
}
\arguments{
\item{object}{an object of class \sQuote{pomp}, or of a class that extends \sQuote{pomp}.
This will typically be the output of \code{pomp}, \code{simulate}, or one of the \pkg{pomp} inference algorithms.}

\item{y}{a matrix containing observations.
The dimensions of \code{y} are \code{nobs} x \code{ntimes}, where \code{nobs} is the number of observables
and \code{ntimes} is the length of \code{times}.}

\item{x}{an array containing states of the unobserved process.
The dimensions of \code{x} are \code{nvars} x \code{nrep} x \code{ntimes},
where \code{nvars} is the number of state variables,
\code{nrep} is the number of replicates,
and \code{ntimes} is the length of \code{times}.
One can also pass \code{x} as a named numeric vector, which is equivalent to the \code{nrep=1}, \code{ntimes=1} case.}

\item{times}{a numeric vector (length \code{ntimes}) containing times.
These must be in non-decreasing order.}

\item{params}{a \code{npar} x \code{nrep} matrix of parameters.
Each column is treated as an independent parameter set, in correspondence with the corresponding column of \code{x}.}

\item{\dots}{additional arguments are ignored.}

\item{log}{if TRUE, log probabilities are returned.}
}
\value{
\code{dmeasure} returns a matrix of dimensions \code{nreps} x \code{ntimes}.
If \code{d} is the returned matrix, \code{d[j,k]} is the likelihood (or log likelihood if \code{log = TRUE}) of the observation \code{y[,k]} at time \code{times[k]} given the state \code{x[,j,k]}.
}
\description{
\code{dmeasure} evaluates the probability density of observations given states.
}
\seealso{
Specification of the measurement density evaluator: \code{\link{dmeasure_spec}}

Other pomp workhorses: 
\code{\link{dprior}()},
\code{\link{dprocess}()},
\code{\link{flow}()},
\code{\link{partrans}()},
\code{\link{rinit}()},
\code{\link{rmeasure}()},
\code{\link{rprior}()},
\code{\link{rprocess}()},
\code{\link{skeleton}()},
\code{\link{workhorses}}
}
\concept{pomp workhorses}
