% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workhorses.R
\docType{methods}
\name{dprocess}
\alias{dprocess}
\alias{dprocess,pomp-method}
\alias{dprocess-pomp}
\alias{dprocess,ANY-method}
\alias{dprocess,missing-method}
\title{dprocess}
\usage{
\S4method{dprocess}{pomp}(object, x, times, params, ..., log = FALSE)
}
\arguments{
\item{object}{an object of class \sQuote{pomp}, or of a class that extends \sQuote{pomp}.
This will typically be the output of \code{pomp}, \code{simulate}, or one of the \pkg{pomp} inference algorithms.}

\item{x}{an array containing states of the unobserved process.
The dimensions of \code{x} are \code{nvars} x \code{nrep} x \code{ntimes},
where \code{nvars} is the number of state variables,
\code{nrep} is the number of replicates,
and \code{ntimes} is the length of \code{times}.
One can also pass \code{x} as a named numeric vector, which is equivalent to the \code{nrep=1}, \code{ntimes=1} case.}

\item{times}{a numeric vector (length \code{ntimes}) containing times.
These must be in non-decreasing order.}

\item{params}{a \code{npar} x \code{nrep} matrix of parameters.
Each column is treated as an independent parameter set, in correspondence with the corresponding column of \code{x}.}

\item{...}{additional arguments are ignored.}

\item{log}{if TRUE, log probabilities are returned.}
}
\value{
\code{dprocess} returns a matrix of dimensions \code{nrep} x \code{ntimes-1}.
If \code{d} is the returned matrix, \code{d[j,k]} is the likelihood (or the log likelihood if \code{log=TRUE}) of the transition from state \code{x[,j,k-1]} at time \code{times[k-1]} to state \code{x[,j,k]} at time \code{times[k]}.
}
\description{
Evaluates the probability density of a sequence of consecutive state transitions.
}
\seealso{
Specification of the process-model density evaluator: \code{\link{dprocess_spec}}

Other pomp workhorses: 
\code{\link{dmeasure}()},
\code{\link{dprior}()},
\code{\link{flow}()},
\code{\link{partrans}()},
\code{\link{rinit}()},
\code{\link{rmeasure}()},
\code{\link{rprior}()},
\code{\link{rprocess}()},
\code{\link{skeleton}()},
\code{\link{workhorses}}
}
\concept{pomp workhorses}
