% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_belief.R
\name{update_belief}
\alias{update_belief}
\title{Belief Update}
\usage{
update_belief(
  model,
  belief = NULL,
  action = NULL,
  observation = NULL,
  episode = 1,
  digits = 7,
  drop = TRUE
)
}
\arguments{
\item{model}{a \link{POMDP} object.}

\item{belief}{the current belief state.
Defaults to the start belief state specified in
the model or "uniform".}

\item{action}{the taken action. Can also be a vector of multiple actions or, if missing, then all actions are evaluated.}

\item{observation}{the received observation. Can also be a vector of multiple observations or, if missing, then all observations are evaluated.}

\item{episode}{Use transition and observation matrices for the given episode
for time-dependent POMDPs (see \link{POMDP}).}

\item{digits}{round decimals.}

\item{drop}{logical; drop the result to a vector if only a single belief
state is returned.}
}
\value{
returns the updated belief state as a named vector.
If \code{action} or \code{observations} is a vector with multiple elements ot missing, then a matrix with all
resulting belief states is returned.
}
\description{
Update the belief given a taken action and observation.
}
\details{
Update the belief state \eqn{b} (\code{belief}) with an action \eqn{a} and observation \eqn{o}. The new
belief state \eqn{b'} is:

\deqn{b'(s') = \eta O(o | s',a) \sum_{s \in S} T(s' | s,a) b(s)}

where \eqn{\eta = 1/ \sum_{s' \in S}[ O(o | s',a) \sum_{s \in S} T(s' | s,a) b(s)]} normalizes the new belief state so the probabilities add up to one.
}
\examples{
data(Tiger)

update_belief(c(.5,.5), model = Tiger)
update_belief(c(.5,.5), action = "listen", observation = "tiger-left", model = Tiger)
update_belief(c(.15,.85), action = "listen", observation = "tiger-right", model = Tiger)

}
\seealso{
Other POMDP: 
\code{\link{POMDP}()},
\code{\link{plot_belief_space}()},
\code{\link{sample_belief_space}()},
\code{\link{simulate_POMDP}()},
\code{\link{solve_POMDP}()},
\code{\link{solve_SARSOP}()},
\code{\link{transition_matrix}()},
\code{\link{write_POMDP}()}
}
\author{
Michael Hahsler
}
\concept{POMDP}
