\name{summary.polywog}
\alias{summary.polywog}
\title{Summarize a fitted polywog model}
\usage{
  \method{summary}{polywog} (object, level = 0.95,
    prop0 = FALSE, ...)
}
\arguments{
  \item{object}{a fitted model of class \code{"polywog"},
  typically the output of \code{\link{polywog}}.}

  \item{level}{width of the bootstrap confidence interval
  to compute for the model coefficients.}

  \item{prop0}{logical: whether to print the proportion of
  bootstrap iterations in which each coefficient was
  estimated as exactly 0.  This may be informative but
  should \emph{not} be interpreted as a p-value.}

  \item{...}{other arguments, currently ignored.}
}
\value{
  An object of class \code{"summary.polywog"} whose
  elements are the "regression table" (\code{coefficients})
  and additional information from the original fitted
  model.
}
\description{
  Generate a "regression table" to summarize the fitted
  model, including coefficients along with their
  bootstrapped standard errors and confidence intervals.
  If the fitted model does not have a \code{boot.matrix}
  element, the output will contain \code{NA}s for the
  standard errors, and confidence intervals will not be
  displayed.
}
\author{
  Brenton Kenkel and Curtis S. Signorino
}

