% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aiding_functions.R
\name{selSegtypeInfo}
\alias{selSegtypeInfo}
\title{Restrict a list of segregation types to specified inheritance modes}
\usage{
selSegtypeInfo(segtypeInfo, polysomic, disomic, mixed)
}
\arguments{
\item{segtypeInfo}{a list as returned by calcSegtypeInfo}

\item{polysomic}{If TRUE all segtypes with poly TRUE are retained, and from
those segtypes all parental dosage combinations with parmode[,1] TRUE}

\item{disomic}{If TRUE all segtypes with di TRUE are retained, and from
those segtypes all parental dosage combinations with parmode[,2] TRUE}

\item{mixed}{If TRUE all segtypes with mixed TRUE are retained, and from
those segtypes all parental dosage combinations with parmode[,3] TRUE}
}
\value{
A list like segtypeInfo, modified as specified by parameters polysomic,
disomic and mixed
}
\description{
From a list of segregation types as produced by calcSegtypeInfo,
this function selects only those segtypes that occur with polysomic,
disomic and/or mixed inheritance if the corresponding parameters are set to
TRUE, and from those segtypes only the parental dosages with the same
restrictions are retained.
}
