% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aiding_functions.R
\name{getConsensusGeno}
\alias{getConsensusGeno}
\title{getConsensusGeno ***********************************************************}
\usage{
getConsensusGeno(geno, maxNAfrac = 0.499, lowconf.NAfrac = 0.751)
}
\arguments{
\item{geno}{A vector with scores (0..ploidy or NA) for all samples of one parent.}

\item{maxNAfrac}{The maximum fraction of missing scores allowed to assign a high-confidence 
consensus geno score; if more are missing a missing geno score is returned (the default requires 
MORE than half of the samples to be scored, so one missing out of 2 samples already causes a missing geno)}

\item{lowconf.NAfrac}{if the fraction missing scores is more than \code{maxNAfrac} but less than \code{lowconf.NAfrac}, 
or if there is only one sample, a \code{lowconf.geno} score is assigned}
}
\value{
Returns a list with 4 components:
\item{geno}{ 
The consensus of the dosages in vector geno. NA if geno is empty,
if all elements of geno are NA, if there are different non-NA
values in geno, or if the fraction of NA values in geno larger than \code{maxNAfrac}
}
\item{lowconf.geno}{
If there is no conflict and the fraction of missing scores
is between \code{maxNAfrac} and \code{lowconf.NAfrac}, the consensus is assigned
as a "low-confidence" geno - this needs confirmation from the
F1 segregation to be accepted}
\item{conflict}{ 
\code{TRUE} if there are different non-NA values in geno, else \code{FALSE}
}
\item{NAfrac}{ 
The fraction NA in geno (0.5 if length(geno)==0)
}
}
\description{
Get consensus genotype
}
