% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/google_transliterate.R
\name{google_transliterate}
\alias{google_transliterate}
\title{Transliterate a single word or a sentence to the required language.}
\usage{
google_transliterate(text, language_tag = "el", num = 5)
}
\arguments{
\item{text}{The word or sentence to transliterate from Latin/Roman (English) script.}

\item{language_tag}{The target language's ISO639 code. The default value for this argument is "el" for Greek.}

\item{num}{The maximum number of suggestions to fetch. The default value for this argument is 5.}
}
\value{
Character vector of transliterated sentences or larger pieces of text.
}
\description{
Transliterate a single word or a sentence to the required language.
}
\examples{
\dontrun{
google_transliterate("Hello world", "fr", 10)
google_transliterate("hello", "el", 10)
}
}
