% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_charpolynom.R, R/method_coef.R,
%   R/method_degree.R, R/method_predict.R, R/method_show.R
\name{charpolynom}
\alias{charpolynom}
\alias{charpolynom,matrix-method}
\alias{charpolynom,polynomial-method}
\alias{charpolynom,polyMatrix-method}
\alias{[[,polyMatrixCharPolynomial,ANY-method}
\alias{degree,polyMatrixCharPolynomial-method}
\alias{predict,polyMatrixCharPolynomial-method}
\alias{show,polyMatrixCharPolynomial-method}
\title{Characteristic polynomial of matrix}
\usage{
charpolynom(x)

\S4method{charpolynom}{matrix}(x)

\S4method{charpolynom}{polynomial}(x)

\S4method{charpolynom}{polyMatrix}(x)

\S4method{[[}{polyMatrixCharPolynomial,ANY}(x, i)

\S4method{degree}{polyMatrixCharPolynomial}(x)

\S4method{predict}{polyMatrixCharPolynomial}(object, newdata)

\S4method{show}{polyMatrixCharPolynomial}(object)
}
\arguments{
\item{x}{an matrix}

\item{i}{the degree to extract polinomial coefficient}

\item{object}{an \R object}

\item{newdata}{the value to evaluate}
}
\value{
When the input is a numerical matrix of \code{matrix} class
then the value is a \code{polynomial} object.

When the input is a \code{polyMatrix} object
then a value is \code{polyMatrixCharClass} class object,
}
\description{
Characteristic polynomial of matrix
}
\details{
The characteristic polynom of a polynomial matrix is a polynom with polynomial coefficients.
}
\section{Methods (by class)}{
\itemize{
\item \code{matrix}: for numerical matrix it is a polynomial with numerical coefficients

\item \code{polynomial}: for polynomial it treats as a matrix 1x1

\item \code{polyMatrix}: for polynomial matrix it has polynomial coefficients

\item \code{x = polyMatrixCharPolynomial,i = ANY}: get polynomial coefficient of characteristic

\item \code{polyMatrixCharPolynomial}: the degree of char polynomail of polynomial matrix

\item \code{polyMatrixCharPolynomial}: value of char polynomail in polynomial point

\item \code{polyMatrixCharPolynomial}: prints out a text representation of a characteristic polinomial of
polinomial matrix
}}

\examples{

# numerical matrices
m <- matrix(c(2, 1,
             -1, 0), 2, 2, byrow=TRUE)
charpolynom(m)
}
\seealso{
\link{polyMatrixCharClass}
}
