% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S4classes.R, R/p_attributes.R, R/count.R,
%   R/context.R, R/enrich.R, R/regions.R, R/trim.R
\docType{class}
\name{context-class}
\alias{context-class}
\alias{show,context-method}
\alias{[,context-method}
\alias{[,context,ANY,ANY,ANY-method}
\alias{[[,context-method}
\alias{summary,context-method}
\alias{head,context-method}
\alias{as.DataTables,context-method}
\alias{length,context-method}
\alias{p_attributes,context-method}
\alias{count,context-method}
\alias{sample,context-method}
\alias{enrich,context-method}
\alias{as.regions,context-method}
\alias{trim,context-method}
\title{Context class.}
\usage{
\S4method{length}{context}(x)

\S4method{p_attributes}{context}(.Object)

\S4method{count}{context}(.Object)

\S4method{sample}{context}(x, size)

\S4method{enrich}{context}(
  .Object,
  s_attribute = NULL,
  p_attribute = NULL,
  decode = FALSE,
  stat = FALSE,
  verbose = TRUE,
  ...
)

\S4method{as.regions}{context}(x, node = TRUE)

\S4method{trim}{context}(
  .Object,
  s_attribute = NULL,
  positivelist = NULL,
  p_attribute = p_attributes(.Object),
  regex = FALSE,
  stoplist = NULL,
  fn = NULL,
  verbose = TRUE,
  progress = TRUE,
  ...
)
}
\arguments{
\item{x}{A \code{context} object.}

\item{.Object}{A \code{context} object.}

\item{size}{An \code{integer} indicating sample size.}

\item{s_attribute}{The s-attribute(s) to add to \code{data.table} in slot \code{cpos}.}

\item{p_attribute}{The p-attribute(s) to add to \code{data.table} in slot \code{cpos}.}

\item{decode}{A \code{logical} value, whether to convert integer ids to expressive
strings.}

\item{stat}{A \code{logical} value, whether to generate / update slot \code{stat} from
the \code{cpos} table.}

\item{verbose}{A \code{logical}, whether to be talkative.}

\item{...}{To maintain backwards compatibility if argument \code{pAttribute} is
still used.}

\item{node}{A logical value, whether to include the node (i.e. query matches) in the region matrix
generated when creating a \code{partition} from a \code{context}-object.}

\item{positivelist}{Tokens that are required to be present to keep a match.}

\item{regex}{A \code{logical} value, whether arguments \code{positivlist} / \code{stoplist}
are interpreted as regular expressions.}

\item{stoplist}{Tokens that are used to exclude a match.}

\item{fn}{A function that will be applied on context tables splitted by
match_id.}

\item{progress}{A \code{logical} value, whether to show progress bar}
}
\description{
Class to organize information of context analysis.
}
\details{
Objects of the class \code{context} include a \code{data.table} in the
slot \code{cpos}. The \code{data.table} will at least include the columns "match_id",
"cpos" and "position".

The \code{length}-method will return the number of hits that were achieved.

The \code{enrich()}-method can be used to add additional information to
the \code{data.table} in the \code{cpos}-slot of a \code{context}-object.
}
\section{Slots}{

\describe{
\item{\code{query}}{The query examined (\code{character}).}

\item{\code{count}}{An \code{integer} value, the number of hits for the query.}

\item{\code{partition}}{The \code{partition} the \code{context} object is based on.}

\item{\code{size_partition}}{The size of the partition, a length-one \code{integer} vector.}

\item{\code{left}}{A length-one \code{integer} value, the number of tokens to the left of the query match.}

\item{\code{right}}{An \code{integer} value, the number of tokens to the right of the query match.}

\item{\code{size}}{A length-one \code{integer} value, the number of tokens covered by
the \code{context}-object, i.e. the number of tokens in the right and left context
of the node as well as query matches.}

\item{\code{size_match}}{A length-one \code{integer} value, the number of tokens
matches by the query. Identical with the value in slot \code{count} if the query
is \emph{not} a CQP query.}

\item{\code{size_coi}}{A length-one \code{integer} value, the number of tokens in the
right and left context of the node (excluding query matches).}

\item{\code{size_ref}}{A length-one \code{integer} value, the number of tokens in the
partition, without tokens matched and the tokens in the left and right
context.}

\item{\code{boundary}}{An s-attribute (\code{character}).}

\item{\code{p_attribute}}{The p-attribute of the query (\code{character}).}

\item{\code{corpus}}{The CWB corpus used (\code{character}).}

\item{\code{stat}}{A \code{data.table}, the statistics of the analysis.}

\item{\code{encoding}}{Object of class \code{character}, encoding of the corpus.}

\item{\code{cpos}}{A \code{data.table}, with the columns match_id, cpos, position, word_id.}

\item{\code{method}}{A \code{character}-vector, statistical test used.}

\item{\code{call}}{Object of class \code{character}, call that generated the object.}
}}

\examples{
# Keep matches for 'oil' only if first position to the left is 'crude'
.fn <- function(x) if (x[position == -1L][["word"]] == "crude") x else NULL
crude_oil <- context("REUTERS", "oil") \%>\%
  enrich(p_attribute = "word", decode = TRUE) \%>\%
  trim(fn = .fn)
}
