% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.markdown.R
\docType{methods}
\name{as.markdown}
\alias{as.markdown}
\alias{as.markdown,partition-method}
\alias{as.markdown,plpr_partition-method}
\title{Get markdown-formatted full text of a partition.}
\usage{
as.markdown(.Object, ...)

\S4method{as.markdown}{partition}(.Object, meta = getOption("polmineR.meta"),
  template = get_template(.Object), cpos = TRUE, cutoff = NULL,
  verbose = FALSE, ...)

\S4method{as.markdown}{plpr_partition}(.Object, meta = NULL,
  template = get_template(.Object), cpos = FALSE, interjections = TRUE,
  cutoff = NULL, ...)
}
\arguments{
\item{.Object}{The object to be converted, a \code{partition}, or a class
inheriting from \code{partition}, such as \code{plpr_partition}.}

\item{...}{further arguments}

\item{meta}{The metainformation (s-attributes) to be displayed.}

\item{template}{A template for formating output.}

\item{cpos}{A \code{logical} value, whether to add cpos as ids in span elements.}

\item{cutoff}{The maximum number of tokens to reconstruct, to avoid that full text is
excessively long.}

\item{verbose}{A \code{logical} value, whether to output messages.}

\item{interjections}{A \code{logical} value, whether to format interjections.}
}
\description{
The method is the worker behind the \code{read}-method, which will be called
usually to reconstruct the full text of a \code{partition} and read it. The
\code{as.markdown}-method can be customized for different classes inheriting
from the \code{partition}-class.
}
\examples{
use("polmineR")
P <- partition("REUTERS", places = "argentina")
as.markdown(P)
as.markdown(P, meta = c("id", "places"))
if (interactive()) read(P, meta = c("id", "places"))
}
