% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expr__expr.R
\name{Expr_rpow}
\alias{Expr_rpow}
\alias{rpow}
\alias{\%**\%}
\alias{\%**\%.Expr}
\title{Reverse exponentiation \verb{\%**\%}(in R \verb{** == ^})}
\usage{
Expr_rpow(base)

e1 \%**\% e2

`\%**\%.Expr`(e1, e2)
}
\arguments{
\item{base}{real or Expr, the value of the base, self is the exponent}

\item{e1}{value where ** operator is defined}

\item{e2}{value where ** operator is defined}
}
\value{
Expr
}
\description{
Raise a base to the power of the expression as exponent.
}
\details{
do not use \verb{**}, R secretly parses that just as if it was a \code{^}
}
\examples{
pl$DataFrame(list(a = -1:3))$select(
  pl$lit(2)$rpow(pl$col("a"))
)$get_column("a")$to_r() == (-1:3)^2

pl$DataFrame(list(a = -1:3))$select(
  pl$lit(2) \%**\% (pl$col("a"))
)$get_column("a")$to_r() == (-1:3)^2
}
\keyword{Expr}
