% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expr__datetime.R
\name{ExprDT_week}
\alias{ExprDT_week}
\alias{(Expr)$dt$week}
\title{Week}
\format{
function
}
\value{
Expr of week as UInt32
}
\description{
Extract the week from the underlying Date representation.
Applies to Date and Datetime columns.
Returns the ISO week number starting from 1.
The return value ranges from 1 to 53. (The last week of year differs by years.)
}
\examples{
df = pl$DataFrame(
  date = pl$date_range(
    as.Date("2020-12-25"),
    as.Date("2021-1-05"),
    interval = "1d",
    time_zone = "GMT",
    lazy = FALSE
  )
)
df$with_columns(
  pl$col("date")$dt$week()$alias("week")
)
}
\keyword{ExprDT}
