% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_competitiveness.R
\name{compute_competitiveness}
\alias{compute_competitiveness}
\title{Calcula Competitividad  (\emph{Computes Competitiveness})}
\usage{
compute_competitiveness(data, level = "provincia")
}
\arguments{
\item{data}{un tibble guardado como objeto en el Enviroment luego de consultar \code{\link{get_election_data}} 
(\emph{A tibble saved as an object in the Enviroment after querying \code{\link{get_election_data}}}).}

\item{level}{un character que establece el nivel de agregacion sobre el que se quiere calcular la competitividad: 
por defualt es \code{provincia} y se desagregan las observaciones asignando los valores \code{departamento} o \code{circuito} al parametro
(\emph{Establishes the level of aggregation on which you want to compute competitiveness: by definition it is \code{provincia} 
and the observations are disaggregated by assigning the values \code{departamento} or \code{circuito} to the parameter}).}
}
\value{
devuelve un tibble con \code{class "tbl_df","tbl", "data.frame"} con el computo de competitividad de una elccion. El resultado puede 
 ser un valor entre 0 y 1, 
 los cuales representan falta de competencia y competitivdad maxima, respectivamente 
 (\emph{returns a tibble with \code{class "tbl_df", "tbl", "data.frame"} with the computation of the level of competitiveness of an elction. 
 The result can be a value between 0 and 1, which represent a lack of competition and maximum competitiveness, respectively}).
}
\description{
Funcion que describe el grado de competencia de una eleccion
 (\emph{Function that describes the degree of competition of an election})
}
\details{
\eqn{Competitividad} mide la diferencia porcentual de votos válidos obtenidos por los dos partidos más votados \eqn{a} y \eqn{b}. 
 Puede tomar valores entre \eqn{[0,1]} donde \eqn{1} es lo más comeptitivo (\eqn{a = 50\%} y \eqn{b = 50\%} de los votos).
  La fórmula utilizada es:  \deqn{Competitividad = 1 - (a - b)}

\strong{REQUISITO:}

El formato de \code{data} debe ser \code{long} para calcular \code{\link{compute_competitiveness}}. 
 Si \code{data} es \emph{wide} se puede transformar con \code{\link{make_long}} 
 (\emph{\code{long} format of \code{data} is required for \code{\link{compute_competitiveness}}. If \code{data} is in \emph{wide} format
 you can transform it with \code{\link{make_long}}}).
}
\examples{

   tucuman_dip_gral_2017

   tucuman_dip_gral_2017 \%>\% 
     compute_competitiveness()
     
}
\seealso{
\code{\link{compute_nep}, \link{compute_seats}, \link{compute_disproportion}}
}
