% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poker.R
\name{dotFlush}
\alias{dotFlush}
\title{dotFlush}
\usage{
dotFlush(cards, score)
}
\arguments{
\item{cards}{: \tabular{ll}{the 7 card hand as
matrix[nPlayers, 14] \tab \cr \tab
col1: rank of card 1 in \{2, ... , 14\} \cr \tab
col2: suit of card 1 in \{1, 2, 3, 4\} \cr \tab
col3: rank of card 2 \cr \tab
col4: suit of card 2 \cr \tab
. \cr \tab
. \cr \tab
. \cr \tab
col13: rank of card 7 \cr \tab
col14: suit of card 7}}

\item{score}{: \tabular{ll}{the score of the hand in absolute terms as
vector[nPlayers] \tab \cr \tab
 9 = Straight Flush \cr \tab
 8 = Four of a Kind \cr \tab
 7 = Full House \cr \tab
 6 = Flush \cr \tab
 5 = Straight \cr \tab
 4 = Three of a Kind \cr \tab
 3 = Two Pair \cr \tab
 2 = One Pair \cr \tab
 1 = High Card}}
}
\value{
winner : absolute position of the winner as
											vector
}
\description{
Determine the player with the highest flush.
}
\examples{
cards <- c(2,1,3,3,5,2,6,3,7,3,13,3,14,3,2,3,3,4,5,1,6,3,7,3,13,3,14,3)
cards <- matrix(cards,2,14,byrow=TRUE); cards
score <- showdown(cards); score
dotFlush(cards,score)

cards <- c(2,1,3,3,5,3,6,3,7,3,13,3,14,3,2,3,3,4,5,3,6,3,7,3,13,3,14,3)
cards <- matrix(cards,2,14,byrow=TRUE);cards
score <- showdown(cards); score 
dotFlush(cards,score)
}
\seealso{
\code{\link{dotFlushRanker}} and \code{\link{dotHighcardCompare}}
}
