% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove_deactivate.R
\name{activate_steps}
\alias{activate_steps}
\title{Activate one or more of an \emph{agent}'s validation steps}
\usage{
activate_steps(agent, i = NULL)
}
\arguments{
\item{agent}{An agent object of class \code{ptblank_agent}.}

\item{i}{The validation step number, which is assigned to each validation
step in the order of definition.}
}
\value{
A \code{ptblank_agent} object.
}
\description{
If certain validation steps need to be activated after the creation of the
validation plan for an \emph{agent}, use the \code{activate_steps()} function. This is
equivalent to using the \code{active = TRUE} for the selected validation steps
(\code{active} is an argument in all validation functions). This will replace any
function that may have been defined for the \code{active} argument during creation
of the targeted validation steps.
}
\section{Function ID}{

9-6
}

\examples{
# Create an agent that has the
# `small_table` object as the
# target table, add a few inactive
# validation steps, and then use
# `interrogate()`
agent_1 <- 
  create_agent(
    read_fn = ~ small_table,
    tbl_name = "small_table",
    label = "An example."
  ) \%>\%
  col_exists(
    vars(date),
    active = FALSE
  ) \%>\%
  col_vals_regex(
    vars(b), regex = "[0-9]-[a-z]{3}-[0-9]{3}",
    active = FALSE
  ) \%>\%
  interrogate()

# In the above, the data is
# not actually interrogated
# because the `active` setting
# was `FALSE` in all steps; we
# can selectively change this
# with `activate_steps()`
agent_2 <-
  agent_1 \%>\%
  activate_steps(i = 1) \%>\%
  interrogate()

}
\seealso{
For the opposite behavior, use the \code{\link[=deactivate_steps]{deactivate_steps()}} function.

Other Object Ops: 
\code{\link{deactivate_steps}()},
\code{\link{export_report}()},
\code{\link{remove_read_fn}()},
\code{\link{remove_steps}()},
\code{\link{remove_tbl}()},
\code{\link{set_read_fn}()},
\code{\link{set_tbl}()},
\code{\link{x_read_disk}()},
\code{\link{x_write_disk}()}
}
\concept{Object Ops}
