% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/object_ops.R
\name{x_write_disk}
\alias{x_write_disk}
\title{Write a \strong{pointblank} \emph{agent} or \emph{informant} to disk}
\usage{
x_write_disk(x, filename, path = NULL, keep_tbl = FALSE, keep_extracts = FALSE)
}
\arguments{
\item{x}{An \emph{agent} object of class \code{ptblank_agent}, or, an \emph{informant} of
class \code{ptblank_informant}.}

\item{filename}{The filename to create on disk for the \code{agent} or
\code{informant}.}

\item{path}{An optional path to which the file should be saved (this is
automatically combined with \code{filename}).}

\item{keep_tbl}{An option to keep a data table that is associated with the
\emph{agent} or \emph{informant} (which is the case when the \emph{agent}, for example, is
created using \verb{create_agent(tbl = <data table, ...)}). The default is
\code{FALSE} where the data table is removed before writing to disk. For
database tables of the class \code{tbl_dbi} and for Spark DataFrames
(\code{tbl_spark}) the table is always removed (even if \code{keep_tbl} is set to
\code{TRUE}).}

\item{keep_extracts}{An option to keep any collected extract data for failing
rows. By default, this is \code{FALSE}.}
}
\description{
Writing an \emph{agent} or \emph{informant} to disk with \code{x_write_disk()} can be useful
for keeping data validation intel or table information close at hand for
later retrieval (with \code{\link[=x_read_disk]{x_read_disk()}}). By default, any data table that the
\emph{agent} or \emph{informant} may have held before being committed to disk will be
expunged. This behavior can be changed by setting \code{keep_tbl} to \code{TRUE} but
this only works in the case where the table is not of the \code{tbl_dbi} or the
\code{tbl_spark} class.
}
\details{
It is recommended to set a table-reading function for later reuse of the
\emph{agent} and \emph{informant} after being read from disk through \code{\link[=x_read_disk]{x_read_disk()}}.
This can be done initially with the \code{read_fn} argument of
\code{\link[=create_agent]{create_agent()}}/\code{\link[=create_informant]{create_informant()}} or, later, with \code{\link[=set_read_fn]{set_read_fn()}}.
Alternatively, we can reintroduce the \emph{agent} or \emph{informant} to a data table
with the \code{\link[=set_tbl]{set_tbl()}} function.
}
\section{Function ID}{

8-1
}

\seealso{
Other Object Ops: 
\code{\link{remove_read_fn}()},
\code{\link{remove_tbl}()},
\code{\link{set_read_fn}()},
\code{\link{set_tbl}()},
\code{\link{x_read_disk}()}
}
\concept{Object Ops}
