% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_yaml.R
\name{agent_yaml_string}
\alias{agent_yaml_string}
\title{Display \strong{pointblank} YAML using an agent or a YAML file}
\usage{
agent_yaml_string(agent = NULL, path = NULL)
}
\arguments{
\item{agent}{An \emph{agent} object of class \code{ptblank_agent} that is created with
\code{\link[=create_agent]{create_agent()}}.}

\item{path}{A path to a YAML file that specifies a validation plan for an
\emph{agent}.}
}
\description{
With \strong{pointblank} YAML, we can serialize an agent's validation plan (with
\code{\link[=agent_yaml_write]{agent_yaml_write()}}), read it back later with a new agent (with
\code{\link[=agent_yaml_read]{agent_yaml_read()}}), or perform an interrogation on the target data table
directly with the YAML file (with \code{\link[=agent_yaml_interrogate]{agent_yaml_interrogate()}}). The
\code{agent_yaml_string()} function allows us to inspect the YAML generated by
\code{\link[=agent_yaml_write]{agent_yaml_write()}} in the console, giving us a look at the YAML without
needing to open the file directly. Alternatively, we can provide an \emph{agent}
to the \code{agent_yaml_string()} and view the YAML representation of the
validation plan without needing to write the YAML to disk beforehand.
}
\section{Function ID}{

7-4
}

\examples{
# Let's create a validation plan for the
# data quality analysis of the `small_table`
# dataset; we need an agent and its
# table-reading function enables retrieval
# of the target table
agent <- 
  create_agent(
    read_fn = ~small_table,
    name = "example",
    actions = action_levels(
      warn_at = 0.10,
      stop_at = 0.25,
      notify_at = 0.35
    )
  ) \%>\%
  col_exists(vars(date, date_time)) \%>\%
  col_vals_regex(
    vars(b), "[0-9]-[a-z]{3}-[0-9]{3}"
  ) \%>\%
  rows_distinct() \%>\%
  col_vals_gt(vars(d), 100) \%>\%
  col_vals_lte(vars(c), 5)

# We can view the YAML file in the console
# with the `agent_yaml_string()` function,
# providing the `agent` object as the input
agent_yaml_string(agent = agent)

# The agent can be written to a pointblank
# YAML file with `agent_yaml_write()`
# agent_yaml_write(agent, filename = "x.yml")

# The 'x.yml' file is available in the package
# through `system.file()`
yml_file <- 
  system.file("x.yml", package = "pointblank")

# The `agent_yaml_string()` function can
# be used with the YAML file as well
agent_yaml_string(path = yml_file)

# At a later time, the YAML file can
# be read into a new agent with the
# `agent_yaml_read()` function
agent <- agent_yaml_read(path = yml_file)

class(agent)
  
}
\seealso{
Other pointblank YAML: 
\code{\link{agent_yaml_interrogate}()},
\code{\link{agent_yaml_read}()},
\code{\link{agent_yaml_show_exprs}()},
\code{\link{agent_yaml_write}()}
}
\concept{pointblank YAML}
