% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yaml_write.R
\name{yaml_agent_string}
\alias{yaml_agent_string}
\title{Display \strong{pointblank} YAML using an agent or a YAML file}
\usage{
yaml_agent_string(agent = NULL, filename = NULL, path = NULL, expanded = FALSE)
}
\arguments{
\item{agent}{An \emph{agent} object of class \code{ptblank_agent}. If an object is
provided here, then \code{filename} must not be provided.}

\item{filename}{The name of the YAML file that contains fields related to an
\emph{agent}. If a file name is provided here, then \emph{agent} object must not be
provided in \code{agent}.}

\item{path}{An optional path to the YAML file (combined with \code{filename}).}

\item{expanded}{Should the written validation expressions for an \emph{agent} be
expanded such that \strong{tidyselect} expressions for columns are evaluated,
yielding a validation function per column? By default, this is \code{FALSE}
so expressions as written will be retained in the YAML representation.}
}
\value{
Nothing is returned. Instead, text is printed to the console.
}
\description{
With \strong{pointblank} YAML, we can serialize an agent's validation plan (with
\code{\link[=yaml_write]{yaml_write()}}), read it back later with a new agent (with
\code{\link[=yaml_read_agent]{yaml_read_agent()}}), or perform an interrogation on the target data table
directly with the YAML file (with \code{\link[=yaml_agent_interrogate]{yaml_agent_interrogate()}}). The
\code{yaml_agent_string()} function allows us to inspect the YAML generated by
\code{\link[=yaml_write]{yaml_write()}} in the console, giving us a look at the YAML without needing
to open the file directly. Alternatively, we can provide an \emph{agent} to the
\code{yaml_agent_string()} and view the YAML representation of the validation plan
without needing to write the YAML to disk beforehand.
}
\section{Examples}{


There's a YAML file available in the \strong{pointblank} package that's called
\code{"agent-small_table.yml"}. The path for it can be accessed through
\code{system.file()}:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{yml_file_path <- 
  system.file(
    "yaml", "agent-small_table.yml",
    package = "pointblank"
  )
}\if{html}{\out{</div>}}

We can view the contents of the YAML file in the console with the
\code{yaml_agent_string()} function.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{yaml_agent_string(filename = yml_file_path)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode yaml">}}\preformatted{type: agent
tbl: ~ tbl_source("small_table", "tbl_store.yml")
tbl_name: small_table
label: A simple example with the `small_table`.
lang: en
locale: en
actions:
  warn_fraction: 0.1
  stop_fraction: 0.25
  notify_fraction: 0.35
steps:
- col_exists:
    columns: vars(date)
- col_exists:
    columns: vars(date_time)
- col_vals_regex:
    columns: vars(b)
    regex: '[0-9]-[a-z]\{3\}-[0-9]\{3\}'
- rows_distinct:
    columns: ~
- col_vals_gt:
    columns: vars(d)
    value: 100.0
- col_vals_lte:
    columns: vars(c)
    value: 5.0
}\if{html}{\out{</div>}}

Incidentally, we can also use \code{yaml_agent_string()} to print YAML in the
console when supplying an \emph{agent object} as the input. This can be useful for
previewing YAML output just before writing it to disk with \code{\link[=yaml_write]{yaml_write()}}.
}

\section{Function ID}{

11-5
}

\seealso{
Other pointblank YAML: 
\code{\link{yaml_agent_interrogate}()},
\code{\link{yaml_agent_show_exprs}()},
\code{\link{yaml_exec}()},
\code{\link{yaml_informant_incorporate}()},
\code{\link{yaml_read_agent}()},
\code{\link{yaml_read_informant}()},
\code{\link{yaml_write}()}
}
\concept{pointblank YAML}
