\name{plot.poLCA}
\alias{plot.poLCA}
\title{Plot results of an estimated latent class model}
\description{
Plots estimated class-conditional response probabilities contained in an object of class poLCA as generated by \code{\link{poLCA}}.  It also shows the estimated population proportion in each class.  Useful for visualization of results and interpretation of "meanings" of groupings uncovered by the latent class model.}
\usage{
plot.poLCA(x, ...)
}
\arguments{
  \item{x}{An object of class poLCA.}
  \item{...}{additional arguments.}
}
\details{
If all manifest variables are dichotomous, the plot shows the estimated probability of an affirmative outcome on each manifest variable, by latent class.  If any of the manifest variables are polytomous, the plot shows the estimated class-conditional response probabilities for every outcome on the manifest variables.
}
\note{
This function is simply an elaborate invocation of the \code{\link[scatterplot3d:scatterplot3d]{scatterplot3d}} command in the \pkg{scatterplot3d} package.
}
\seealso{ \code{\link{poLCA}} }
\examples{
# Model with only dichotomous manifest variables
data(values)
f1 <- cbind(A,B,C,D)~1
M1 <- poLCA(f1,values,nclass=2,verbose=FALSE)
plot(M1)

# Model with polytomous manifest variables
data(gss82)
f2 <- cbind(PURPOSE,ACCURACY,UNDERSTA,COOPERAT)~1
M2 <- poLCA(f2,gss82,nclass=3,maxiter=2000)
plot(M2)
}
\keyword{hplot}

