% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metar_get_historical.R
\name{metar_get_historical}
\alias{metar_get_historical}
\title{Get historical METAR reports.}
\usage{
metar_get_historical(
  airport = "EPWA",
  start_date = "2020-01-01",
  end_date = "2020-01-10",
  from = "iastate"
)
}
\arguments{
\item{airport}{character;  ICAO or IATA airport code.}

\item{start_date}{character; start date in the format YYYY-MM-DD.}

\item{end_date}{character; end date in the format YYYY-MM-DD.}

\item{from}{character; selection of online METAR database, \cr
the default value is "iastate" downolading METAR reports from
Iowa Environmental Mesonet ASOS-AWOS-METAR
\url{https://mesonet.agron.iastate.edu/AWOS/}. \cr
Setting the parameter from to "ogimet" allows to use Weather Information Service provided by Ogimet
\url{https://www.ogimet.com/}.}
}
\value{
a data frame character vectors with historical METAR weather report.
}
\description{
Download a set of historical METAR weather reports.
The default source is the Iowa Environmental
Mesonet web page of Iowa State University ASOS-AWOS-METAR\cr
\url{https://mesonet.agron.iastate.edu/AWOS/}\cr
The secondary source of METAR reports is Weather Information Service provided by Ogimet
\url{https://www.ogimet.com/}. However for this source
the requested period is limited to 31 days. METAR reports are available from
the year 2005.
}
\examples{
metar_get_historical("EPWA", start_date = "2017-11-20", end_date = "2017-11-25")
metar_get_historical("MAD", start_date = "2015-06-01", end_date = "2015-06-02",
from = "iastate")
\donttest{
metar_get_historical("CYUL", start_date = "2016-07-01", end_date = "2016-07-05",
from = "ogimet")
}

}
