% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/panel_consistency.R
\name{fixed_force}
\alias{fixed_force}
\title{Enforce consistency in variables}
\usage{
fixed_force(
  .df,
  .var = NULL,
  .within = NULL,
  .resolve = mode_order,
  .flag = NA
)
}
\arguments{
\item{.df}{Data frame, pibble, or tibble.}

\item{.var}{Quoted or unquoted variable(s) in \code{.df} that should be consistent. If not specified, uses all variables in \code{.df} that are not in \code{.within}.}

\item{.within}{Quotes or unquoted variable(s) that the \code{.var} variables should be consistent within.}

\item{.resolve}{Function capable of being passed to \code{dplyr::summarize()} that will be used to resolve inconsistencies. Or, set to \code{'drop'} or any string to drop all inconsistent observations. By default, this will return the mode (ties use the first observed value).}

\item{.flag}{String indicating the name of a new variable that flags any observations altered by \code{fixed_force()}.}
}
\description{
This function forces values the variables in \code{.var} to take constant values within combinations of the variables in \code{.within}. \code{fixed_force()} will return a data frame with consistency enforced.
}
\details{
Inconsistencies will be resolved by the function \code{.resolve}. Or, set \code{.resolve} to \code{'drop'} (or any string, really) to drop all cases with inconsistency.
}
\examples{

data(Scorecard)
# The variables pred_degree_awarded_ipeds and state_abbr should be constant within unitid
# However, sometimes colleges change what they offer.
# For the purpose of my analysis, though,
# I want to treat any changers as whatever they are most often (the mode).
# So let's enforce that with fixed_force
Scorecard <- fixed_force(Scorecard,
  .var = c(pred_degree_awarded_ipeds, state_abbr),
  .within = unitid, .flag = "changed"
)
# Did we catch any changers?
table(Scorecard$changed)
# We did!
}
