% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/id_variable.R
\name{id_variable}
\alias{id_variable}
\title{Create a single panel ID variable out of several}
\usage{
id_variable(..., .method = "number", .minwidth = FALSE)
}
\arguments{
\item{...}{variables (vectors) that, together, make up the ID variables in the data and uniquely identifies the individual. Note that \code{id_variable()} will not check whether you've selected an appropriate set of variables; try running \code{as_pibble()} after getting your ID and time variables.}

\item{.method}{Can be \code{'number'}, \code{'random'}, or \code{'character'}, as described below.}

\item{.minwidth}{If \code{.method = 'character'}, omits the additional spacing that makes the ID variable fixed-width and ensures uniqueness. WARNING: This option saves space but may in rare cases cause two individuals to have the same ID. Defaults to \code{FALSE}.}
}
\description{
The pmdplyr library accepts the use of multiple ID variables. However, you may wish to combine these into a single variable, or renumber the single variable you already have for some reason.
}
\details{
By default, id_variable() will create a unique numeric identifier out of your ID variables, sequential following the order in the original data (\code{.method='number'}). However, you may want to remove the ordering and assign IDs randomly (\code{.method='random'}), or preserve all the original information and create a single fixed-width character ID variable that contains all the original information (\code{.method='character'}).
}
\examples{

data(SPrail)
# I want to identify observations at the route (origin-destination)/year level
# Let's make it a character variable so we can tell at a glance what route we're talking
SPrail <- SPrail \%>\%
  dplyr::mutate(route_id = id_variable(origin, destination, .method = "character"))
}
