\name{Read Me First}
\alias{readme}
\alias{CHECK}
\alias{CLASS.spmd}
\alias{COMM.RANK}
\alias{COMM.SIZE}
\alias{SAVE.param}
\alias{SAVE.iter}
\alias{U.spmd}
\alias{W.spmd}
\alias{W.spmd.rowSums}
\alias{Z.colSums}
\alias{Z.spmd}
\alias{p.times.logtwopi}
\alias{readme.dmat}
\alias{CLASS.dmat}
\alias{U.dmat}
\alias{W.dmat}
\alias{W.dmat.rowSums}
\alias{Z.dmat}
\title{Read Me First Function}
\description{
  This function print the annotations of all variables used in this package.

  \code{*.dmat}'s are \code{ddmatrix} versions.
}
\usage{
  readme()

  readme.dmat()
}
\details{
  This package is optimized in the way by pre-specifying several global
  variables in \code{.pmclustEnv}.
  These variables will be overwrote by EM algorithms. Users should
  use these names to access the results and utilize them with cautions.

  \code{readme.dmat} is a ddmatrix version of \code{readme}.
}
\value{
  A readme message will print on screen by default and explain the global
  variables used in this package, including:
\tabular{ll}{\code{CHECK}            \tab convergent checking \cr
             \code{CLASS.spmd}       \tab true id of each data, a vector of
                                          length N.spmd and has values
                                          from 1 to K \cr
             \code{COMM.RANK}        \tab rank of current processor, obtained
                                          from
                                          \code{comm.rank} of pbdMPI\cr
             \code{COMM.SIZE}        \tab total processors in MPI world,
                                          obtained from
                                          \code{comm.size} of pbdMPI\cr
             \code{\link{CONTROL}}   \tab controls for EM iterations \cr
             \code{\link{PARAM}}     \tab set or parameters \cr
             \code{SAVE.param}       \tab (debug only)
                                          save parameters for every
                                          iterations \cr
             \code{SAVE.iter}        \tab (debug only)
                                          save computing time for every
                                          iterations \cr
             \code{U.spmd}           \tab temporary storage for density \cr
             \code{W.spmd}           \tab temporary storage for
                                          \code{eta * density} \cr
             \code{W.spmd.rowSums}   \tab temporary storage for rowSums
                                          of \code{W.spmd} \cr
             \code{\link{X.spmd}}    \tab generated data set with dimension
                                          with dimension
                                          \code{N.spmd * p} \cr
             \code{Z.colSums}        \tab temporary storage for rowSums
                                          of \code{Z.spmd} \cr
             \code{Z.spmd}           \tab posterior probabilities \cr
             \code{p.times.logtwopi} \tab \code{p * log(2 * pi)}
}
  Each variable may contain several elements if it is a list, some variables
  are used for temporary storages in order to optimize computing, and some
  variables are used for constant variables. These variables may be restricted,
  and only generated by the function \code{\link{set.global}}.

  One can access these variables via the global environment \code{.pmclustEnv}
  such as \code{.pmclustEnv$CONTROL}.
}
\references{
  % High Performance Statistical Computing (HPSC) Website:
  % \url{http://thirteen-01.stat.iastate.edu/snoweye/hpsc/}

  Programming with Big Data in R Website:
  \url{http://r-pbd.org/}
}
\author{
  Wei-Chen Chen \email{wccsnow@gmail.com} and George Ostrouchov.
}
\seealso{
  \code{\link{set.global}},
  \code{\link{set.global.dmat}}.
}
\examples{
\dontrun{
readme()
readme.dmat()
}
}
\keyword{global variables}

