% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{gamlassoFit}
\alias{gamlassoFit}
\title{The function fitting a gamlasso model}
\usage{
gamlassoFit(data, formula = NULL, response.name = NULL,
  linear.name = NULL, smooth.name = NULL, family = "gaussian",
  linear.penalty = 0, smooth.penalty = 2, offset.name = NULL,
  weights.name = NULL, num.knots = 5, num.iter = 100,
  interactions = F, tolerance = 1e-04, seed = .Random.seed[1],
  verbose = TRUE)
}
\arguments{
\item{data}{The training data for fitting the model}

\item{formula}{A formula describing the model to be fitted}

\item{response.name}{The name of the response variable. Vector of two if
\code{family = "binomial"}}

\item{linear.name}{The names of the variables to be used as linear predictors}

\item{smooth.name}{The names of the variables to be used as smoothers}

\item{family}{The family describing the error distribution and link function
to be used in the model. A character string which can only be
\code{"gaussian"} (default), \code{"binomial"}, \code{"poisson"} or
\code{"cox"}. For \code{family = "binomial"}, \code{response} can be
a vector of two and for \code{family="cox"}, \code{weights} must
be provided (see details below).}

\item{linear.penalty}{The penalty used on the linear predictors. Can be 0, 1 or 2}

\item{smooth.penalty}{The penalty used on the smoothers. Can be 1 or 2}

\item{offset.name}{The name of the offset variable. \code{NULL} (default) if not provided}

\item{weights.name}{The name of the weights variable. \code{NULL} (default)
if not provided. See \code{Details} of \code{\link{gamlasso}}.}

\item{num.knots}{Number of knots for each smoothers. Can be a single integer
(recycled for each smoother variable) or a vector of integers the same length
as the number of smoothers.}

\item{num.iter}{Number of iterations for the gamlasso loop}

\item{interactions}{logical. Should interactions be included.}

\item{tolerance}{Tolerance for covergence of the gamlasso loop}

\item{seed}{The random seed can be specified for reproducibility. This is used
for fitting the gam and lasso models, or fixed before each loop of gamlasso.}

\item{verbose}{logical. Should there be "progress reports" printed to the
console while fitting the model.}
}
\value{
See \code{\link{gamlasso}}
}
\description{
This function is the workhorse for fitting a gamlasso model. Not recommended
to call directly. It is slightly more efficient than \code{gamlasso.default} since
it doesn't perform any quality checks. Only use if the data has been cleaned
and no errors are expected to occur.
}
\examples{
## Not recommended to use directly. Please see examples of gamlasso
}
