% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SPA.R
\name{spa_pls}
\alias{spa_pls}
\title{Sub-window permutation analysis coupled with PLS (SwPA-PLS)}
\usage{
spa_pls(y, X, ncomp = 10, N = 3, ratio = 0.8, Qv = 10, SPA.threshold = 0.05)
}
\arguments{
\item{y}{vector of response values (\code{numeric} or \code{factor}).}

\item{X}{numeric predictor \code{matrix}.}

\item{ncomp}{integer number of components (default = 10).}

\item{N}{number of Monte Carlo simulations (default = 3).}

\item{ratio}{the proportion of the samples to use for calibration (default = 0.8).}

\item{Qv}{integer number of variables to be sampled in each iteration (default = 10).}

\item{SPA.threshold}{thresholding to remove non-important variables (default = 0.05).}
}
\value{
Returns a vector of variable numbers corresponding to the model 
having lowest prediction error.
}
\description{
SwPA-PLS provides the influence of each variable without considering the 
influence of the rest of the variables through sub-sampling of samples and variables.
}
\examples{
data(gasoline, package = "pls")
with( gasoline, spa_pls(octane, NIR) )

}
\references{
H. Li, M. Zeng, B. Tan, Y. Liang, Q. Xu, D. Cao, Recipe for revealing 
informative metabolites based on model population analysis, Metabolomics 6 (2010) 353-361.
http://code.google.com/p/spa2010/downloads/list.
}
\seealso{
\code{\link{VIP}} (SR/sMC/LW/RC), \code{\link{filterPLSR}}, \code{\link{shaving}}, 
\code{\link{stpls}}, \code{\link{truncation}},
\code{\link{bve_pls}}, \code{\link{ga_pls}}, \code{\link{ipw_pls}}, \code{\link{mcuve_pls}},
\code{\link{rep_pls}}, \code{\link{spa_pls}},
\code{\link{lda_from_pls}}, \code{\link{lda_from_pls_cv}}, \code{\link{setDA}}.
}
\author{
Tahir Mehmood, Kristian Hovde Liland, Solve Sæbø.
}
