% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/palettes.R
\name{colorConversions}
\alias{col2hsl}
\alias{col2rgb.2}
\alias{colorConversions}
\alias{hsl2col}
\alias{hsl2rgb}
\alias{rgb2col}
\alias{rgb2hsl}
\title{Convert colors from and to RGB and HSL formats}
\usage{
col2rgb.2(col)

col2hsl(col)

hsl2col(hsl)

rgb2col(rgb)

rgb2hsl(rgb)

hsl2rgb(hsl)
}
\arguments{
\item{col}{a character vector with colors to convert (palette)}

\item{hsl}{a numeric matrix with three or four rows (hue, saturation, luminosity and alpha)}

\item{rgb}{a numeric matrix with three or four rows (red, green, blue and alpha)}
}
\value{
col2rgb.2 and col2hsl return a four-row matrix. rgb2col and hsl2col return a character
        vector.
}
\description{
Convert colors from and to RGB and HSL formats
}
\details{
These functions convert between RGB and HSL color spaces, and character
vectors which contain color names or hash-encoded RGB values ("#FFCC00").

All functions support an alpha channel. For example,
unlike the grDevices::col2rgb, col2rgb.2 returns a matrix with four
rows: three for R, G and B channels and one for the alpha channel.
}
\section{Functions}{
\itemize{
\item \code{col2rgb.2}: Convert a character vector of color names
(palette) to a matrix with RGB values

\item \code{col2hsl}: Convert a character vector of color names (palette) to a matrix with HSL values

\item \code{hsl2col}: Convert hsl matrix (3 or 4 row) to character vector of color names

\item \code{rgb2col}: Convert rgb matrix (3 or 4 row) to character vector of color names

\item \code{rgb2hsl}: Convert a 3- or 4-row matrix of RGB(A) values to a matrix of HSL(A) values

\item \code{hsl2rgb}: Convert a matrix of HSL values into a matrix of RGB values
}}
\examples{
haze <- plotPals("haze")
col2rgb(haze)
col2hsl(haze)
}
\seealso{
\code{\link{modCol}}, \code{\link{modhueCol}}, \code{\link{darkenCol}}, \code{\link{saturateCol}}
}

