% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theming.R
\name{theme_box}
\alias{theme_box}
\title{Box theme}
\usage{
theme_box(
  xlen_npc = 0.15,
  ylen_npc = 0.15,
  xlab = "",
  ylab = "",
  lab_size = 12,
  ...
)
}
\arguments{
\item{xlen_npc}{The length of the x-axis arrow in "npc".}

\item{ylen_npc}{The length of the y-axis arrow in "npc".}

\item{xlab}{x-axis label.}

\item{ylab}{y-axis label.}

\item{lab_size}{Label size.}

\item{...}{Arguments passed to the \code{\link[ggplot2]{theme}}.}
}
\value{
A ggplot2 theme.
}
\description{
This function creates a theme with all elements blank except for axis lines
like a box around the plot.
}
\examples{
library(ggplot2)
p <- ggplot(mtcars, aes(x = wt, y = mpg, colour = factor(cyl))) +
    geom_point()
p + theme_box()
}
