% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image_modify_rgb_v.R
\name{image_modify_rgb_v}
\alias{image_modify_rgb_v}
\title{Modify R, G, B Values according to 
V values}
\usage{
image_modify_rgb_v(x, fun_r = NULL, fun_g = NULL, fun_b = NULL,
  alpha = FALSE, rescale_v = NULL, result = "magick", res = 144)
}
\arguments{
\item{x}{an image created 
by \code{magick::image_read} or 
other functions in package magick.}

\item{fun_r, fun_g, fun_b}{a function or a list which 
designates an internal curve. See the Details part of 
\code{\link{image_modify_hsv}}.}

\item{alpha}{whether to allow 
the output colors have transparency. Default is FALSE.}

\item{rescale_v}{You can rescale the V values before 
modifying colors. A desired range of V values can 
be given, 
e. g., \code{rescale_v = c(0.2, 1)} which 
will make the smallest original value to 
be 0.2, and the largest, 1. Alternatively, 
it can be your own scaling function.}

\item{result}{the default is "magick", the output is 
a magick picture. When it is "raster", a matrix is created 
which can be use as a raster 
for \code{ggplot2::annotation_raster}.}

\item{res}{when the result is a magick picture, the 
\code{res} parameter used by \code{magick::image_graph}.
Default is 144.}
}
\description{
While the \code{\link{image_modify_rgb}} 
function modifies R, G, B with reference to 
the original values, 
\code{image_modify_rgb_v} also takes into 
account the brightness (V) values. It is similar 
to those apps which devide an image into 
a bright part and a dark part (and, for 
example, you can increase red in the 
bright part and decrease red in the 
dark part.
}
\details{
This function uses custom functions 
or internal curves to 
make modification. See the Details part 
of \code{\link{image_modify_hsv}} to 
know how to use them. Note: values will 
be coerced to be in the [0, 255] range with 
no warning. For example, the original value 
is 240 and it becomes 280 in the output, then 
it will be set to 255 automatically.
}
