% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_ellipse_cm.R
\name{geom_ellipse_cm}
\alias{geom_ellipse_cm}
\title{Geom Layer for Ellipse with Absolute Size}
\usage{
geom_ellipse_cm(mapping = NULL, data = NULL, stat = "identity",
  position = "identity", na.rm = FALSE, show.legend = NA,
  inherit.aes = TRUE, ...)
}
\arguments{
\item{mapping}{aes mapping.}

\item{data}{data.}

\item{stat}{stat.}

\item{position}{position.}

\item{na.rm}{logical, whether to remove NA values.}

\item{show.legend}{whether to show legend.}

\item{inherit.aes}{logical, whether to inherit aes from ggplot().}

\item{...}{additional parameters.}
}
\description{
This layer uses centimeter as unit to draw ellipse so 
that its size and shape will not be influenced by 
the coordinate systems 
(even when a polar system is used).
}
\details{
Accepted properties are: 
\itemize{
  \item (1) \code{rcm} radius in centimeter.
  \item (2) \code{ab} it means to what extent 
radius a of an ellipse is larger than radius b.
However, its true meaning is the aspect ratio which 
is used by \code{gridExtra::ellipseGrob} and indicates 
the extent to which y dimension is flattened. So, say, 
when \code{ab = 2}, radius a is larger than b, but it is 
not exactly 2 times larger. 
  \item (3) \code{color} color of the the outline.
  \item (4) \code{fill} color inside the shape.
  \item (5) \code{alpha} alpha of color and fill.
  \item (6) \code{size} line width of the outline.
  \item (7) \code{linetype} line type.
  \item (8) \code{angle} angle of rotation from 0
degree and in anti-clockwise direction.
  \item (9) \code{n} the number of points to 
draw the shape. Note: it must be written inside 
the \code{aes(...)} function.
  \item (10) \code{x} x coordinates of middle points. 
  \item (11) \code{y} y coordinates of middle points.
}
}
\examples{
library(ggplot2)
dat=data.frame(x=c(1, 3, 5, 7, 9), y=rep(5, 5)) 
ggplot(dat)+xlim(0, 11)+ylim(1, 9)+
	geom_ellipse_cm(aes(x=x, y=y), fill="red", ab=seq(1, 4, length.out=5))  
ggplot(dat)+xlim(0, 11)+ylim(1, 9)+
	geom_ellipse_cm(aes(x=x, y=y, fill=factor(x)), ab=3, angle=c(0, pi/4, pi/3, pi/2, 0.75*pi))
}
