% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_shading_bar.R
\name{gg_shading_bar}
\alias{gg_shading_bar}
\title{Drawing Barplot with Shading Colors}
\usage{
gg_shading_bar(v, labels = NULL, raster = NULL, flip = FALSE,
  change_order = "normal", equal_scale = FALSE, smooth = 15,
  interpolate = TRUE, width = 0.8, color = NA, linetype = 1,
  size = 1, modify_raster = TRUE, ...)
}
\arguments{
\item{v}{a vector of item frequencies.
Negative values are OK.}

\item{labels}{a vector of item names.
Its length should be equal to that of \code{v}.
If it is NULL, default names will be used.
If it is of class numeric or factor, it will be 
transformed to a character vector.}

\item{raster}{a list. The length of the list 
should be equal to that of \code{v}. 
Each element of the list should be 
a color vector corresponding to a value 
in \code{v}. If it is a vector, it will be 
automatically transformed to a list. 
If its length is 1, but the length of 
\code{v} is, say, 3, then it will be 
automatically repeated for 3 times.
Let us suppose \code{v = 5} 
and \code{raster = list(c("green", "red"))}.
This means the starting side of the bar is 
green and the far side is red. See examples.}

\item{flip}{default is FALSE and the bars 
are vertical. When it is TRUE, the bars are 
horizontal. Note: when using this function, 
\bold{DO NOT USE} 
\code{ggplot2::coord_flip} !}

\item{change_order}{when it is "normal" (default), 
the drawing order is the order of \code{v}.
When it is "big", big values will be drawn first.
When it is "small", small values will be drawn first.
When it is "rev", the inverse order of \code{v} 
will be used.}

\item{equal_scale}{default is FALSE. When it is 
TRUE, a bar will use a certain part of the shading 
colors according to a global scale. See examples.}

\item{smooth}{default is 15. The number of 
shading colors each bar has. The bigger, the better.}

\item{interpolate}{when it is TRUE (default), it 
makes the colors smoother.}

\item{width}{the width of each bar. It should be 
between 0 and 1.}

\item{color}{color of the outlines of the bars.}

\item{linetype}{line type of the outlines 
of the bars.}

\item{size}{line width of the outlines of the bars.}

\item{modify_raster}{if it is TRUE (default), colors 
will be smoothed using the value of \code{smooth}. 
If \code{raster} has enough colors, you can set 
this to FALSE.}

\item{...}{additional arguments used by 
\code{ggplot2::coord_flip} when \code{flip = TRUE}.}
}
\description{
In ordinary barplot, each bar has only one color.
This function aims to draw a barplot whose bars 
have shading effect. Note: unlike 
\code{ggplot2::geom_bar}, this function can only 
deals with a vector of frequencies.
}
\examples{
library(ggplot2)
x=c(10, 30, 25, 6)
lab=c("children", "youth", "middle", "aged")
r=list(c("cyan", "red"), c("blue", "yellow"), 
	c("green", "orange"), c("grey", "black"))
#
## (1) change_order
# change_order = "ordinary", the default
p1=gg_shading_bar(v=x, labels=lab)
# change_order = "big"
p2=gg_shading_bar(v=x, labels=lab, change_order="big")
# flip and let the largest on the top
p3=gg_shading_bar(v=x, labels=lab, 
	change_order="small", flip=TRUE)
#
## (2) how to use argument raster
p1=gg_shading_bar(v=x, labels=lab, raster=r)
p2=gg_shading_bar(v=x, labels=lab, raster=c("green","red"))
#
## (3) how to use argument equal_scale
# equal_scale = FALSE
# the far side of each bar is red
gg_shading_bar(c(3, 5), raster=c("green", "red"))
# equal_scale = TRUE
# the far side of the shorter bar 
# is not red. Rather, it is something
#' between red and green
gg_shading_bar(c(3, 5), raster=c("green", "red"), 
	equal_scale=TRUE)
}
