% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_each_column.R
\name{count_each_column}
\alias{count_each_column}
\title{Counting Each Column and Summarizing in a Matrix}
\usage{
count_each_column(x, answer = NULL, checks = TRUE)
}
\arguments{
\item{x}{a data frame or matrix with at least 1 row and 
1 column. NOTE: all column should belong to the same 
class (numeric, character). 
However, if \code{checks = TRUE}, character and 
factor variables can co-exist and logical values are also OK. 
If a column has nothing but 
NA, it should be remove; otherwise, an error will be raised.}

\item{answer}{the values whose frequencies you 
want to know, e. g., "agree" and "disagree" 
in your survey data. Default is NULL which means 
all possibble answers in the whole data will be used.}

\item{checks}{whether to check the validity of the 
input data. Default is TRUE. Do not turn it off unless you 
are sure that your data has no logical variables or factor 
variables and each column has at least 1 non-missing value.}
}
\description{
This function counts the frequencies of each element of each 
column of a data frame or matrix. The frequencies of 
missing values and the 0 frequencies of non-existent 
values are also included in the final result.
}
\examples{
# values that do not appear in 
# the data can also be counted.
# a factor will be transformed into
# a character variable automatically.
x1=c("a", "b", "a", "b", NA)
x2=factor(x1)
x3=c("1", "3", "2", "1", "a")
dat=data.frame(x1, x2, x3, stringsAsFactors=FALSE)
res=count_each_column(dat, answer=c("c", "d", NA, "a"))
# logical value is OK.
x1=c(TRUE, TRUE, TRUE)
x2=c(TRUE, NA, NA)
dat=data.frame(x1, x2)
res=count_each_column(dat)
res=count_each_column(dat, c(TRUE, FALSE))
}
