% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_roc.R
\docType{data}
\name{StatRoc}
\alias{StatRoc}
\alias{stat_roc}
\title{Calculate the empirical Receiver Operating Characteristic curve}
\format{An object of class \code{StatRoc} (inherits from \code{Stat}, \code{ggproto}) of length 5.}
\usage{
StatRoc

stat_roc(mapping = NULL, data = NULL, geom = "roc",
  position = "identity", show.legend = NA, inherit.aes = TRUE,
  na.rm = TRUE, ...)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link{aes}} or \code{\link{aes_string}}. Only needs to be set
at the layer level if you are overriding the plot defaults.}

\item{data}{A layer specific dataset - only needed if you want to override
the plot defaults.}

\item{geom}{The geometric object to use display the data}

\item{position}{The position adjustment to use for overlapping points
on this layer}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link{borders}}.}

\item{na.rm}{Remove missing observations}

\item{...}{other arguments passed on to \code{\link{layer}}. This can
include aesthetics whose values you want to set, not map. See
\code{\link{layer}} for more details.}
}
\description{
Given a binary outcome d and continous measurement m, computes the empirical
ROC curve for assessing the classification accuracy of m
}
\section{Aesthetics}{

\code{stat_roc} understands the following aesthetics (required aesthetics
are in bold):
\itemize{
  \item \strong{\code{m}} The continuous biomarker/predictor
  \item \strong{\code{d}} The binary outcome, if not coded as 0/1, the 
  smallest level in sort order is assumed to be 0, with a warning
  \item \code{alpha}
  \item \code{color}
  \item \code{linetype}
  \item \code{size}
}
}

\section{Computed variables}{

\describe{
  \item{false_positive_fraction}{estimate of false positive fraction}
  \item{true_positive_fraction}{estimate of true positive fraction}
  \item{cutoffs}{values of m at which estimates are calculated}
}
}
\examples{
D.ex <- rbinom(250, 1, .5)
rocdata <- data.frame(D = c(D.ex, D.ex), 
                   M = c(rnorm(250, mean = D.ex, sd = .4), rnorm(250, mean = D.ex, sd = 1)), 
                   Z = c(rep("A", 250), rep("B", 250)))

ggplot(rocdata, aes(m = M, d = D)) + stat_roc()
}
\keyword{datasets}

