% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_me.R
\name{plot_me}
\alias{plot_me}
\title{Plot marginal effects from two-way interactions in linear regressions}
\source{
Inspired by:
\url{http://www.statsblogs.com/2013/08/27/creating-marginal-effect-plots-for-linear-regression-models-in-r/}
}
\usage{
plot_me(obj, term1, term2, fitted2, ci = 90, plot = TRUE)
}
\arguments{
\item{obj}{fitted model object from \code{lm}.}

\item{term1}{character string of the first constitutive term of the
interaction's variable name.}

\item{term2}{character string of the second constitutive term of the
interaction's variable name.}

\item{fitted2}{numeric vector of fitted values of \code{term2} to plot for.
If unspecified, then all unique observed values are used.}

\item{ci}{numeric. confidence interval level, expressed on the ]0, 100[]
interval.}

\item{plot}{boolean. return plot if TRUE; return data.frame of marginal
effects estimates if FALSE}
}
\value{
a \code{gg} class ggplot2 object
}
\description{
Plot marginal effects from two-way interactions in linear regressions
}
\examples{
# Estimate model
states <- as.data.frame(state.x77)
m1 <- lm(Murder ~ Income * Population, data = states)

# Plot marginal effect of Income across the observed range of Population
# on the Murder rate
plot_me(m1, 'Income', 'Population', ci = 95)

# Return marginal effects as a data frame
plot_me(m1, 'Income', 'Population', plot = FALSE)



}

