% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multifield3logit.R
\name{multifield3logit}
\alias{multifield3logit}
\alias{+.Hfield3logit}
\alias{print.multifield3logit}
\alias{plot.multifield3logit}
\alias{as_tibble.multifield3logit}
\alias{as.data.frame.multifield3logit}
\alias{fortify.multifield3logit}
\alias{tidy.multifield3logit}
\alias{labels.multifield3logit}
\alias{labels<-.multifield3logit}
\alias{[.multifield3logit}
\alias{[<-.multifield3logit}
\title{Multiple trilogit fields}
\usage{
multifield3logit(x, ...)

\method{+}{Hfield3logit}(x, y)

\method{print}{multifield3logit}(x, maxitems = 10, ...)

\method{plot}{multifield3logit}(x, y = NULL, add = FALSE, col = NA, legend = TRUE, ...)

\method{as_tibble}{multifield3logit}(x, ..., wide = TRUE)

\method{as.data.frame}{multifield3logit}(x, ..., wide = TRUE)

\method{fortify}{multifield3logit}(model, data, ..., wide = TRUE)

\method{tidy}{multifield3logit}(x, ..., wide = TRUE)

\method{labels}{multifield3logit}(object, ...)

\method{labels}{multifield3logit}(object) <- value

\method{[}{multifield3logit}(x, i, drop = TRUE)

\method{[}{multifield3logit}(x, i) <- value
}
\arguments{
\item{x, y, model, object}{object of class \code{field3logit} or \code{multifield3logit}.}

\item{...}{other arguments passed to or from other methods.}

\item{maxitems}{maximum number of items to be enumerated when an object of
class \code{multifield3logit} is printed.}

\item{add}{\code{logical} argument which specifies whether the field
should be added to an existing plot (\code{add = TRUE}) or a new
ternary plot should be drawn (\code{add = FALSE}).}

\item{col, legend}{graphical parameters if \code{Ternary} package is used.}

\item{wide}{it allows to choose whether \code{as.data.frame}, \code{as_tibble},
\code{fortify} and \code{tidy} should return a \code{data.frame} or a \code{tibble} in wide
(default) or long form.}

\item{data}{not used. Argument included only for interface compatibility with
the generic \code{fortify}.}

\item{value}{value to be assigned.}

\item{i}{index of the \code{field3logit} object to be selected.}

\item{drop}{if \code{TRUE}, a \code{field3logit} object is returned if the
subsetted \code{multifield3logit} object has length one.}
}
\value{
\code{S3} object of class \code{multifield3logit} structured as a named \code{list}.
}
\description{
Methods of \code{S3} class \code{multifield3logit} handle multiple \code{fields3logit}
objects simultaneously and permit new \code{multifield3logit} objects to be
easily created by means of the sum operator "\code{+}".
}
\examples{
\dontrun{
data(cross_1year)

mod0 <- nnet::multinom(employment_sit ~ ., data = cross_1year)
mod0

field_Sdur <- field3logit(mod0, 'durationShort',
  label = 'Short duration')
field_Hfgr <- field3logit(mod0, 'finalgradeHigh',
  label = 'High final grade')

gg3logit(field_Sdur + field_Hfgr) +
  stat_field3logit()
  facet_wrap(~ label)

refpoint <- list(c(0.7, 0.15, 0.15))

field_Sdur <- field3logit(mod0, 'durationShort',
  label = 'Short duration', p0 = refpoint, narrows = 1)
field_Ldur <- field3logit(mod0, 'durationLong',
  label = 'Long duration', p0 = refpoint, narrows = 1)
field_Hfgr <- field3logit(mod0, 'finalgradeHigh',
  label = 'High final grade', p0 = refpoint, narrows = 1)
field_Lfgr <- field3logit(mod0, 'finalgradeLow',
  label = 'Low final grade', p0 = refpoint, narrows = 1)

mfields <- field_Sdur + field_Ldur  + field_Lfgr + field_Hfgr
mfields

gg3logit(mfields) +
  stat_field3logit(aes(colour = label)) +
  theme_zoom_L(0.45)
}

}
\seealso{
\code{\link[=field3logit]{field3logit()}}.
}
