% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/P2XB.R
\name{P2XB}
\alias{P2XB}
\alias{P2XB_cat3logit}
\alias{P2XB_ord3logit}
\title{Compute the linear predictors implied by trinomial probability distributions}
\usage{
P2XB(P, model)

P2XB_cat3logit(P)

P2XB_ord3logit(P, alpha)
}
\arguments{
\item{P}{object of class \code{matrix} (or other coercible classes) such that
\eqn{P\in[0,\,1]^{n\times 3}}.}

\item{model}{object of class \code{field3logit}.}

\item{alpha}{\code{numeric} vector of length two where constants \eqn{\alpha^{(1)}}
and \eqn{\alpha^{(2)}} are stored (only for ordinal models), as
defined in Equation (7) of \insertCite{santi2019;textual}{plot3logit}.}
}
\value{
Numeric matrix \eqn{\textbf{R}^{n\times 2}} of linear predictors.
}
\description{
Given the probability distributions \eqn{P\in[0,\,1]^{n\times 3}} of the
dependent variable, it computes the the values of linear predictors
\eqn{XB\in\textbf{R}^{n\times 2}} according to notation used in
\insertCite{santi2019;textual}{plot3logit}.
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{XB2P}}.
}
\keyword{internal}
