% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assignColors.R
\name{assignColors}
\alias{assignColors}
\title{assignColors}
\usage{
assignColors(x, breaks = NULL, col = heat.colors, na.col = "white")
}
\arguments{
\item{x}{numeric or non-numeric vector}

\item{breaks}{vector with breaks}

\item{col}{vector with colors or color function}

\item{na.col}{color for NA or out-of-range values}
}
\value{
vector of color with the same length as \code{x} with the attributes
\code{breaks} the breaks used, \code{col} the color coding and \code{na.col} 
the color for \code{NA} and out-of-range entries
}
\description{
Assign to each value in \code{x} a color according to the choices of \code{breaks} and \code{col}.
}
\details{
Depending if \code{x} is a numeric or non-numeric vector colors 
are assigned to each value. 

In case of a numeric vector \code{breaks} can be 
\itemize{
\item a number, giving the number of intervals covering the range of \code{x},
\item a vector of two numbers, given the range to cover with 10 intervals, or
\item a vector with more than two numbers, specify the interval borders
}
In case of a non-numeric vector \code{breaks} must contain all values which are
will get a color.
If \code{breaks} is not given then a sensible default is choosen: 
in case of a numeric vector derived from \code{\link[base]{pretty}} and 
otherwise all unique values/levels are used.

\code{col} can be either be a vector of colors or a function which generates
via \code{col(n)} a set of \code{n} colors. The default is to use 
\code{\link[grDevices]{heat.colors}}.

Possible color functions in R packages can be found by \code{vignette('plot.matrix')}.
}
\examples{
## numeric vector
x <- runif(10)
assignColors(x)
# set breaks
assignColors(x, breaks=15)
assignColors(x, breaks=c(0,1))
# set colors
assignColors(x, col=c("red", "green", "blue"))
assignColors(x, col=topo.colors)
# NA and out-of-range
x[5] <- NA
assignColors(x, breaks=seq(0.5, 1, by=0.1), na.col="red")
## logical vector
l <- sample(c(NA, TRUE, FALSE), size=10, replace=TRUE)
assignColors(l)
assignColors(l, breaks=c("FALSE", "TRUE"), col=c("red", "blue"))
## character vector
t <- sample(letters, size=10, replace=TRUE)
assignColors(t)
assignColors(t, col=rainbow(5))
}
