% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_uroot.R
\name{phansi}
\alias{phansi}
\alias{print.phansi}
\title{Simes Test for unit roots in panel data}
\usage{
phansi(object, alpha = 0.05)

\method{print}{phansi}(x, cutoff = 10L, ...)
}
\arguments{
\item{object}{either a numeric containing p-values of individual unit root
test results (does not need to be sorted) or a suitable \code{purtest} object
(as produced by \code{purtest()} for a test which gives p-values of the individuals
(Hadri's test in \code{purtest} is not suitable)),}

\item{alpha}{numeric, the pre-specified significance level (defaults to \code{0.05}),}

\item{x}{an object of class \code{c("phansi", "list")} as produced by \code{phansi} to be printed,}

\item{cutoff}{integer, cutoff value for printing of enumeration of individuals with
rejected individual H0, for print method only,}

\item{\dots}{further arguments (currently not used).}
}
\value{
For \code{phansi}, an object of class \code{c("phansi", "list")} which is a list with the elements:
\itemize{
\item \code{id}: integer, the identifier of the individual (integer sequence referring to
position in input),
\item \code{name}: character, name of the input's individual (if it has a name,
otherwise "1", "2", "3", ...),
\item \code{p}: numeric, p-values as input (either the numeric or extracted from
the purtest object),
\item \code{p.hommel}: numeric, p-values after Hommel's transformation,
\item \code{rejected}: logical, indicating for which individual the individual null
hypothesis is rejected (\code{TRUE})/non-rejected (\code{FALSE}) (after controlling
for multiplicity),
\item \code{rejected.no}: integer, giving the total number of rejected individual series,
\item \code{alpha}: numeric, the input \code{alpha}.
}
}
\description{
Simes' test of intersection of individual hypothesis tests
(\insertCite{SIMES:86;textual}{plm}) applied to panel unit root tests as suggested by
\insertCite{HANCK:13;textual}{plm}.
}
\details{
Simes' approach to testing is combining p-values from single hypothesis tests
with a global (intersected) hypothesis. \insertCite{HANCK:13;textual}{plm}
mentions it can be applied to any panel unit root test which yield a p-value
for each individual series.
The test is robust versus general patterns of cross-sectional dependence.

Further, this approach allows to discriminate between individuals for which
the individual H0 (unit root present for individual series) is rejected/is
not rejected by Hommel's procedure (\insertCite{HOMM:88;textual}{plm}) for
family-wise error rate control (FWER) at pre-specified significance level
alpha via argument \code{alpha} (defaulting to \code{0.05}), i.e., it controls for the
multiplicity in testing.

The function \code{phansi} takes as main input \code{object} either a plain numeric
containing p-values of individual tests or a \code{purtest} object which holds
a suitable pre-computed panel unit root test (one that produces p-values per
individual series).

The function's return value (see section Value) is a list with detailed
evaluation of the applied Simes test.

The associated \code{print} method prints a verbal evaluation.
}
\examples{

### input is numeric (p-values)
#### example from Hanck (2013), Table 11 (left side)
pvals <- c(0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0050,0.0050,0.0050,
           0.0050,0.0175,0.0175,0.0200,0.0250,0.0400,0.0500,0.0575,0.2375,0.2475)

countries <- c("Argentina","Sweden","Norway","Mexico","Italy","Finland","France",
              "Germany","Belgium","U.K.","Brazil","Australia","Netherlands",
              "Portugal","Canada", "Spain","Denmark","Switzerland","Japan")
names(pvals) <- countries

h <- phansi(pvals)
print(h)              # (explicitly) prints test's evaluation
print(h, cutoff = 3L) # print only first 3 rejected ids 
h$rejected # logical indicating the individuals with rejected individual H0


### input is a (suitable) purtest object
data("Grunfeld", package = "plm")
y <- data.frame(split(Grunfeld$inv, Grunfeld$firm))
obj <- purtest(y, pmax = 4, exo = "intercept", test = "madwu")

phansi(obj)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[=purtest]{purtest()}}, \code{\link[=cipstest]{cipstest()}}
}
\author{
Kevin Tappe
}
\keyword{htest}
