% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est_vcm.R
\name{pvcm}
\alias{pvcm}
\alias{summary.pvcm}
\alias{print.summary.pvcm}
\title{Variable Coefficients Models for Panel Data}
\usage{
pvcm(formula, data, subset, na.action, effect = c("individual", "time"),
  model = c("within", "random"), index = NULL, ...)

\method{summary}{pvcm}(object, ...)

\method{print}{summary.pvcm}(x, digits = max(3, getOption("digits") - 2),
  width = getOption("width"), ...)
}
\arguments{
\item{formula}{a symbolic description for the model to be estimated,}

\item{data}{a \code{data.frame},}

\item{subset}{see \code{lm},}

\item{na.action}{see \code{lm},}

\item{effect}{the effects introduced in the model: one of
\code{"individual"}, \code{"time"},}

\item{model}{one of \code{"within"}, \code{"random"},}

\item{index}{the indexes, see \code{\link[=pdata.frame]{pdata.frame()}},}

\item{\dots}{further arguments.}

\item{object, x}{an object of class \code{"pvcm"},}

\item{digits}{digits,}

\item{width}{the maximum length of the lines in the print output,}
}
\value{
An object of class \code{c("pvcm", "panelmodel")}, which has the
following elements:

\item{coefficients}{the vector (or the data frame for fixed
effects) of coefficients,}

\item{residuals}{the vector of
residuals,}

\item{fitted.values}{the vector of fitted values,}

\item{vcov}{the covariance matrix of the coefficients (a list for
fixed effects),}

\item{df.residual}{degrees of freedom of the residuals,}

\item{model}{a data frame containing the variables used for the
estimation,}

\item{call}{the call,} \item{Delta}{the estimation of the
covariance matrix of the coefficients (random effect models only),}

\item{std.error}{a data frame containing standard errors for all
coefficients for each individual (within models only).}

\code{pvcm} objects have \code{print}, \code{summary} and \code{print.summary} methods.
}
\description{
Estimators for random and fixed effects models with variable coefficients.
}
\details{
\code{pvcm} estimates variable coefficients models. Time or individual
effects are introduced, respectively, if \code{effect = "time"} or
\code{effect = "individual"} (the default value).

Coefficients are assumed to be fixed if \code{model = "within"} and
random if \code{model = "random"}. In the first case, a different model
is estimated for each individual (or time period). In the second
case, the \insertCite{SWAM:70;textual}{plm} model is estimated. It
is a generalized least squares model which uses the results of the
previous model.
}
\examples{

data("Produc", package = "plm")
zw <- pvcm(log(gsp) ~ log(pcap) + log(pc) + log(emp) + unemp, data = Produc, model = "within")
zr <- pvcm(log(gsp) ~ log(pcap) + log(pc) + log(emp) + unemp, data = Produc, model = "random")

## replicate Greene (2012), p. 419, table 11.14
summary(pvcm(log(gsp) ~ log(pc) + log(hwy) + log(water) + log(util) + log(emp) + unemp, 
             data = Produc, model = "random"))
             
\dontrun{
# replicate Swamy (1970), p. 166, table 5.2
data(Grunfeld, package = "AER") # 11 firm Grunfeld data needed from package AER
gw <- pvcm(invest ~ value + capital, data = Grunfeld, index = c("firm", "year"))
}
             

}
\references{
\insertRef{SWAM:70}{plm}
}
\author{
Yves Croissant
}
\keyword{regression}
