% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/individualQC.R
\name{evaluate_check_sex}
\alias{evaluate_check_sex}
\title{Evaluate results from PLINK sex check.}
\usage{
evaluate_check_sex(qcdir, name, maleTh = 0.8, femaleTh = 0.2,
  externalSex = NULL, fixMixup = FALSE, indir = qcdir,
  externalFemale = "F", externalMale = "M", externalSexSex = "Sex",
  externalSexID = "IID", verbose = FALSE, path2plink = NULL,
  showPlinkOutput = TRUE, interactive = FALSE)
}
\arguments{
\item{qcdir}{[character] /path/to/directory containing name.sexcheck as
returned by plink --check-sex.}

\item{name}{[character] Prefix of PLINK files, i.e. name.bed, name.bim,
name.fam and name.sexcheck.}

\item{maleTh}{[double] Threshold of X-chromosomal heterozygosity rate for
males.}

\item{femaleTh}{[double] Threshold of X-chromosomal heterozygosity rate for
females.}

\item{externalSex}{[data.frame, optional] with sample IDs [externalSexID] and
sex [externalSexSex] to double check if external and PEDSEX data (often
processed at different centers) match.}

\item{fixMixup}{[logical] Should PEDSEX of individuals with mismatch between
PEDSEX and Sex, with Sex==SNPSEX automatically corrected: this will directly
change the name.bim/.bed/.fam files!}

\item{indir}{[character] /path/to/directory containing the basic PLINK data
files name.bim, name.bed, name.fam files; only required of fixMixup==TRUE. User
needs writing permission to indir.}

\item{externalFemale}{[integer/character] Identifier for 'female' in
externalSex.}

\item{externalMale}{[integer/character] Identifier for 'male' in externalSex.}

\item{externalSexSex}{[character] Column identifier for column containing sex
information in externalSex.}

\item{externalSexID}{[character] Column identifier for column containing ID
information in externalSex.}

\item{verbose}{[logical] If TRUE, progress info is printed to standard out.}

\item{path2plink}{[character] Absolute path to directory where external plink
software \url{https://www.cog-genomics.org/plink/1.9/} can be found, i.e.
plink should be accessible as path2plink/plink -h. If not
provided, assumed that PATH set-up works and plink will be found by
system("plink").}

\item{showPlinkOutput}{[logical] If TRUE, plink log and error messages are
printed to standard out.}

\item{interactive}{[logical] Should plots be shown interactively? When
choosing this option, make sure you have X-forwarding/graphical interface
available for interactive plotting. Alternatively, set interactive=FALSE and
save the returned plot object (p_sexcheck) via ggplot2::ggsave(p=p_sexcheck,
other_arguments) or pdf(outfile) print(p_sexcheck) dev.off().}
}
\value{
named list with i) fail_sex: dataframe with FID, IID, PEDSEX, SNPSEX
and Sex (if externalSex was provided) of individuals failing sex check,
ii) mixup: dataframe with FID, IID, PEDSEX, SNPSEX and Sex (if externalSex
was provided) of individuals whose PEDSEX != Sex and Sex == SNPSEX and iii)
p_sexcheck, a ggplot2-object 'containing' a scatter plot of the X-chromosomal
heterozygosity (SNPSEX) of the individuals split by their (PEDSEX), which can
be shown by print(p_sexcheck).
}
\description{
Evaluates and depicts results from plink --check-sex (via
\code{\link{run_check_sex}} or externally conducted sex check).
Takes file qcdir/name.sexcheck and returns IIDs for samples whose
SNPSEX != PEDSEX (where the SNPSEX is determined by the heterozygosity rate
across X-chromosomal variants).
Mismatching SNPSEX and PEDSEX IDs can indicate plating errors, sample-mixup
or generally samples with poor genotyping. In the latter case, these IDs are
likely to fail other QC steps as well.
Optionally, an extra data.frame (externalSex) with sample IDs and sex can be
provided to double check if external and PEDSEX data (often processed at
different centers) match. If a mismatch between PEDSEX and SNPSEX was
detected while SNPSEX == Sex, PEDSEX of these individuals can optionally be
updated (fixMixup=TRUE).
\code{evaluate_check_sex} depicts the X-chromosomal heterozygosity (SNPSEX)
of the samples split by their (PEDSEX).
}
\details{
Both \code{\link{run_check_sex}} and \code{\link{evaluate_check_sex}} can
simply be invoked by \code{\link{check_sex}}.

For details on the output data.frame fail_sex, check the original
description on the PLINK output format page:
\url{https://www.cog-genomics.org/plink/1.9/formats#sexcheck}.
}
\examples{
qcdir <- system.file("extdata", package="plinkQC")
name <- "data"
\dontrun{
fail_sex <- evaluate_check_sex(qcdir=qcdir, name=name, interactive=FALSE,
verbose=FALSE)
}
}
