% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_polygon.R
\name{poly_width_at}
\alias{poly_width_at}
\title{Width at a given height}
\usage{
poly_width_at(
  x,
  at = c(0.05, 0.25, 0.5, 0.75, 0.95),
  unify = FALSE,
  plot = FALSE
)
}
\arguments{
\item{x}{A vector containing two-dimensional data points (often produced with
\link{object_contour}).}

\item{at}{A vector of heights along the vertical axis of the convex hull at
which to count the number of points below. The default value is \code{c(0.05, 0.25, 0.5, 0.75, 0.95)}, which means the function will return the number of
points below the 5th, 25th, 50th, 75th, and 95th percentiles of the convex
hull. If \code{at = "heights"} is used, the function returns the width for each
point of the object length.}

\item{unify}{A logical value indicating whether to use the unified convex
hull calculation method. If unify = TRUE, coordinates in x will be
first bound before computing the convex hull.}

\item{plot}{A logical value that specifies whether the widths should be
plotted.}
}
\value{
A vector with the widths of the convex hull at the specified heights
or a list of vectors with the widths of each component.
}
\description{
The function computes the polygonal convex hull of the points in x and then
returns the number of points that lie below a specified set of heights along
the vertical axis of the convex hull.
}
\details{
The convex hull computed from x is aligned along the major axis and then
converted to a binary image. For each height in the at vector, the function
computes the corresponding row number in the binary image (i.e., the row
number that corresponds to the specified height along the vertical axis of
the convex hull) and sums the values in that row to obtain the number of
points that lie below the specified height. If the convex hull contains
multiple polygons and unify = FALSE, the function loops over each polygon
and returns a list of the number of points below the specified heights for
each polygon. If the convex hull contains only one polygon or multiple
polygons and unify = TRUE, the function returns a vector of the number of
points below the specified heights for that single polygon.
}
\examples{
cont <- contours[[2]]
plot_polygon(cont |> conv_hull() |> poly_align())
#  width below 5th, 25th, 50th, 75th, and 95th percentiles of the length
wd <- poly_width_at(cont)
wd

# width along the height
poly_width_at(cont, at = "height", plot = TRUE)


}
