% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_mosaic.R
\name{mosaic_to_rgb}
\alias{mosaic_to_rgb}
\title{Mosaic to RGB}
\usage{
mosaic_to_rgb(mosaic, r = 3, g = 2, b = 1, coef = 0, plot = TRUE)
}
\arguments{
\item{mosaic}{A mosaic of class \code{SpatRaster}, generally imported with
\code{\link[=mosaic_input]{mosaic_input()}}.}

\item{r}{The layer for the Red band (default: 3).}

\item{g}{The layer for the Green band (default: 2).}

\item{b}{The layer for the Blue band (default: 1).}

\item{coef}{An addition coefficient applied to the resulting object. This is
useful to adjust the brightness of the final image. Defaults to 0.}

\item{plot}{Logical, whether to display the resulting RGB image (default:
TRUE).}
}
\value{
A three-band RGB image represented as a pliman (EBImage) object.
}
\description{
Convert an \code{SpatRaster} to a three-band RGB image of class \code{Image}.
}
\details{
This function converts \code{SpatRaster} that contains the RGB bands into
a three-band RGB image using pliman (EBImage). It allows you to specify the
band indices for the red, green, and blue channels, as well as apply a
scaling coefficient to the final image. By default, the resulting RGB image
is displayed, but this behavior can be controlled using the \code{plot}
parameter.
}
\examples{
library(pliman)
# Convert a mosaic raster to an RGB image and display it
mosaic <- mosaic_input(system.file("ex/elev.tif", package="terra"))

# Convert a mosaic raster to an RGB image without displaying it
rgb_image <- mosaic_to_rgb(c(mosaic * 2, mosaic - 0.3, mosaic * 0.8))
plot(rgb_image)


}
